/*
 * Decompiled with CFR 0.152.
 */
package com.github.hanseter.quadtree.impl;

import com.github.hanseter.quadtree.impl.Quadrant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0018\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0004H\u00c6\u0003J\u000e\u0010\u001c\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004JF\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\"J\u0013\u0010#\u001a\u00020\u001e2\b\u0010$\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J&\u0010'\u001a\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0006\u0010(\u001a\u00020)J\t\u0010*\u001a\u00020+H\u00d6\u0001R \u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0013\u0010\b\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006,"}, d2={"Lcom/github/hanseter/quadtree/impl/Entry;", "T", "", "minX", "", "minY", "maxX", "maxY", "value", "(DDDDLjava/lang/Object;)V", "containingQuadrant", "Lcom/github/hanseter/quadtree/impl/Quadrant;", "getContainingQuadrant", "()Lcom/github/hanseter/quadtree/impl/Quadrant;", "setContainingQuadrant", "(Lcom/github/hanseter/quadtree/impl/Quadrant;)V", "getMaxX", "()D", "getMaxY", "getMinX", "getMinY", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "component2", "component3", "component4", "component5", "contains", "", "x", "y", "copy", "(DDDDLjava/lang/Object;)Lcom/github/hanseter/quadtree/impl/Entry;", "equals", "other", "hashCode", "", "intersects", "remove", "", "toString", "", "quadtree"})
public final class Entry<T> {
    private final double minX;
    private final double minY;
    private final double maxX;
    private final double maxY;
    private final T value;
    public Quadrant<T> containingQuadrant;

    public Entry(double minX, double minY, double maxX, double maxY, T value) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.value = value;
    }

    public final double getMinX() {
        return this.minX;
    }

    public final double getMinY() {
        return this.minY;
    }

    public final double getMaxX() {
        return this.maxX;
    }

    public final double getMaxY() {
        return this.maxY;
    }

    public final T getValue() {
        return this.value;
    }

    @NotNull
    public final Quadrant<T> getContainingQuadrant() {
        Quadrant<T> quadrant = this.containingQuadrant;
        if (quadrant != null) {
            return quadrant;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"containingQuadrant");
        return null;
    }

    public final void setContainingQuadrant(@NotNull Quadrant<T> quadrant) {
        Intrinsics.checkNotNullParameter(quadrant, (String)"<set-?>");
        this.containingQuadrant = quadrant;
    }

    public final void remove() {
        this.getContainingQuadrant().remove(this);
    }

    public final boolean contains(double x, double y) {
        return this.minX <= x && x <= this.maxX && this.minY <= y && y <= this.maxY;
    }

    public final boolean intersects(double minX, double minY, double maxX, double maxY) {
        return this.minX <= maxX && minX <= this.maxX && this.minY <= maxY && minY <= this.maxY;
    }

    public final double component1() {
        return this.minX;
    }

    public final double component2() {
        return this.minY;
    }

    public final double component3() {
        return this.maxX;
    }

    public final double component4() {
        return this.maxY;
    }

    public final T component5() {
        return this.value;
    }

    @NotNull
    public final Entry<T> copy(double minX, double minY, double maxX, double maxY, T value) {
        return new Entry<T>(minX, minY, maxX, maxY, value);
    }

    public static /* synthetic */ Entry copy$default(Entry entry, double d, double d2, double d3, double d4, Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            d = entry.minX;
        }
        if ((n & 2) != 0) {
            d2 = entry.minY;
        }
        if ((n & 4) != 0) {
            d3 = entry.maxX;
        }
        if ((n & 8) != 0) {
            d4 = entry.maxY;
        }
        if ((n & 0x10) != 0) {
            object = entry.value;
        }
        return entry.copy(d, d2, d3, d4, object);
    }

    @NotNull
    public String toString() {
        return "Entry(minX=" + this.minX + ", minY=" + this.minY + ", maxX=" + this.maxX + ", maxY=" + this.maxY + ", value=" + this.value + ")";
    }

    public int hashCode() {
        int result = Double.hashCode(this.minX);
        result = result * 31 + Double.hashCode(this.minY);
        result = result * 31 + Double.hashCode(this.maxX);
        result = result * 31 + Double.hashCode(this.maxY);
        result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Entry)) {
            return false;
        }
        Entry entry = (Entry)other;
        if (Double.compare(this.minX, entry.minX) != 0) {
            return false;
        }
        if (Double.compare(this.minY, entry.minY) != 0) {
            return false;
        }
        if (Double.compare(this.maxX, entry.maxX) != 0) {
            return false;
        }
        if (Double.compare(this.maxY, entry.maxY) != 0) {
            return false;
        }
        return Intrinsics.areEqual(this.value, entry.value);
    }
}

