/*
 * Decompiled with CFR 0.152.
 */
package com.github.hanseter.quadtree;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/github/hanseter/quadtree/QuadtreeOptions;", "", "maxElemsPerQuadrant", "", "initialX", "", "initialY", "initialSize", "(IDDD)V", "getInitialSize", "()D", "getInitialX", "getInitialY", "getMaxElemsPerQuadrant", "()I", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "quadtree"})
public final class QuadtreeOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxElemsPerQuadrant;
    private final double initialX;
    private final double initialY;
    private final double initialSize;
    public static final int ELEMENTS_PER_QUADRANT = 100;
    public static final double DEFAULT_INITIAL_X = -100000.0;
    public static final double DEFAULT_INITIAL_Y = -100000.0;
    public static final double DEFAULT_INITIAL_SIZE = -100000.0;

    public QuadtreeOptions(int maxElemsPerQuadrant, double initialX, double initialY, double initialSize) {
        this.maxElemsPerQuadrant = maxElemsPerQuadrant;
        this.initialX = initialX;
        this.initialY = initialY;
        this.initialSize = initialSize;
    }

    public /* synthetic */ QuadtreeOptions(int n, double d, double d2, double d3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 100;
        }
        if ((n2 & 2) != 0) {
            d = -100000.0;
        }
        if ((n2 & 4) != 0) {
            d2 = -100000.0;
        }
        if ((n2 & 8) != 0) {
            d3 = 200000.0;
        }
        this(n, d, d2, d3);
    }

    public final int getMaxElemsPerQuadrant() {
        return this.maxElemsPerQuadrant;
    }

    public final double getInitialX() {
        return this.initialX;
    }

    public final double getInitialY() {
        return this.initialY;
    }

    public final double getInitialSize() {
        return this.initialSize;
    }

    public final int component1() {
        return this.maxElemsPerQuadrant;
    }

    public final double component2() {
        return this.initialX;
    }

    public final double component3() {
        return this.initialY;
    }

    public final double component4() {
        return this.initialSize;
    }

    @NotNull
    public final QuadtreeOptions copy(int maxElemsPerQuadrant, double initialX, double initialY, double initialSize) {
        return new QuadtreeOptions(maxElemsPerQuadrant, initialX, initialY, initialSize);
    }

    public static /* synthetic */ QuadtreeOptions copy$default(QuadtreeOptions quadtreeOptions, int n, double d, double d2, double d3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = quadtreeOptions.maxElemsPerQuadrant;
        }
        if ((n2 & 2) != 0) {
            d = quadtreeOptions.initialX;
        }
        if ((n2 & 4) != 0) {
            d2 = quadtreeOptions.initialY;
        }
        if ((n2 & 8) != 0) {
            d3 = quadtreeOptions.initialSize;
        }
        return quadtreeOptions.copy(n, d, d2, d3);
    }

    @NotNull
    public String toString() {
        return "QuadtreeOptions(maxElemsPerQuadrant=" + this.maxElemsPerQuadrant + ", initialX=" + this.initialX + ", initialY=" + this.initialY + ", initialSize=" + this.initialSize + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.maxElemsPerQuadrant);
        result = result * 31 + Double.hashCode(this.initialX);
        result = result * 31 + Double.hashCode(this.initialY);
        result = result * 31 + Double.hashCode(this.initialSize);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QuadtreeOptions)) {
            return false;
        }
        QuadtreeOptions quadtreeOptions = (QuadtreeOptions)other;
        if (this.maxElemsPerQuadrant != quadtreeOptions.maxElemsPerQuadrant) {
            return false;
        }
        if (Double.compare(this.initialX, quadtreeOptions.initialX) != 0) {
            return false;
        }
        if (Double.compare(this.initialY, quadtreeOptions.initialY) != 0) {
            return false;
        }
        return Double.compare(this.initialSize, quadtreeOptions.initialSize) == 0;
    }

    public QuadtreeOptions() {
        this(0, 0.0, 0.0, 0.0, 15, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/github/hanseter/quadtree/QuadtreeOptions$Companion;", "", "()V", "DEFAULT_INITIAL_SIZE", "", "DEFAULT_INITIAL_X", "DEFAULT_INITIAL_Y", "ELEMENTS_PER_QUADRANT", "", "quadtree"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

