/*
 * Copyright 2019 Thunderberry.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package nl.altindag.ssl.util;

import nl.altindag.ssl.SSLFactory;
import nl.altindag.ssl.provider.FenixProvider;
import nl.altindag.ssl.provider.SSLFactoryProvider;

import java.security.Provider;

/**
 * @author Hakan Altindag
 */
public final class ProviderUtils {

    private ProviderUtils() {}

    public static Provider create(SSLFactory sslFactory) {
        SSLFactoryProvider.set(sslFactory);
        return new FenixProvider();
    }

}
