/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.sslparameters;

import java.security.AlgorithmConstraints;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.SSLParameters;
import nl.altindag.ssl.sslparameters.DelegatingSSLParameters;
import nl.altindag.ssl.sslparameters.SSLParametersCallable;
import nl.altindag.ssl.sslparameters.SSLParametersRunnable;
import nl.altindag.ssl.util.internal.ValidationUtils;

public final class HotSwappableSSLParameters
extends DelegatingSSLParameters {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();

    public HotSwappableSSLParameters(SSLParameters sslParameters) {
        super(sslParameters);
    }

    @Override
    public void setSslParameters(SSLParameters sslParameters) {
        this.setSafely(() -> super.setSslParameters(ValidationUtils.requireNotNull(sslParameters, (String)ValidationUtils.GENERIC_EXCEPTION_MESSAGE.apply("SSLParameters"))));
    }

    @Override
    public SSLParameters getInnerSslParameters() {
        return this.getSafely(() -> super.getInnerSslParameters());
    }

    @Override
    public String[] getCipherSuites() {
        return this.getSafely(() -> super.getCipherSuites());
    }

    @Override
    public String[] getProtocols() {
        return this.getSafely(() -> super.getProtocols());
    }

    @Override
    public boolean getWantClientAuth() {
        return this.getSafely(() -> super.getWantClientAuth());
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.getSafely(() -> super.getNeedClientAuth());
    }

    @Override
    public AlgorithmConstraints getAlgorithmConstraints() {
        return this.getSafely(() -> super.getAlgorithmConstraints());
    }

    @Override
    public String getEndpointIdentificationAlgorithm() {
        return this.getSafely(() -> super.getEndpointIdentificationAlgorithm());
    }

    @Override
    public void setCipherSuites(String[] cipherSuites) {
        this.setSafely(() -> super.setCipherSuites(cipherSuites));
    }

    @Override
    public void setProtocols(String[] protocols) {
        this.setSafely(() -> super.setProtocols(protocols));
    }

    @Override
    public void setWantClientAuth(boolean wantClientAuth) {
        this.setSafely(() -> super.setWantClientAuth(wantClientAuth));
    }

    @Override
    public void setNeedClientAuth(boolean needClientAuth) {
        this.setSafely(() -> super.setNeedClientAuth(needClientAuth));
    }

    @Override
    public void setAlgorithmConstraints(AlgorithmConstraints constraints) {
        this.setSafely(() -> super.setAlgorithmConstraints(constraints));
    }

    @Override
    public void setEndpointIdentificationAlgorithm(String algorithm) {
        this.setSafely(() -> super.setEndpointIdentificationAlgorithm(algorithm));
    }

    private <V> V getSafely(SSLParametersCallable<V> sslParametersCallable) {
        this.readLock.lock();
        try {
            V v = sslParametersCallable.call();
            return v;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void setSafely(SSLParametersRunnable sslParametersRunnable) {
        this.writeLock.lock();
        try {
            sslParametersRunnable.run();
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

