/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.trustmanager;

import java.net.Socket;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UnsafeX509ExtendedTrustManager
extends X509ExtendedTrustManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnsafeX509ExtendedTrustManager.class);
    private static final X509ExtendedTrustManager INSTANCE = new UnsafeX509ExtendedTrustManager();
    private static final String SERVER = "server";
    private static final String CLIENT = "client";
    private static final String CERTIFICATE_LOG_MESSAGE = "Accepting the following {} certificates without validating: {}";
    private static final X509Certificate[] EMPTY_CERTIFICATES = new X509Certificate[0];

    private UnsafeX509ExtendedTrustManager() {
    }

    public static X509ExtendedTrustManager getInstance() {
        return INSTANCE;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certificates, String authType) {
        UnsafeX509ExtendedTrustManager.logCertificate(certificates, CLIENT);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certificates, String authType, Socket socket) {
        UnsafeX509ExtendedTrustManager.logCertificate(certificates, CLIENT);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certificates, String authType, SSLEngine sslEngine) {
        UnsafeX509ExtendedTrustManager.logCertificate(certificates, CLIENT);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String authType) {
        UnsafeX509ExtendedTrustManager.logCertificate(certificates, SERVER);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String authType, Socket socket) {
        UnsafeX509ExtendedTrustManager.logCertificate(certificates, SERVER);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String authType, SSLEngine sslEngine) {
        UnsafeX509ExtendedTrustManager.logCertificate(certificates, SERVER);
    }

    private static void logCertificate(X509Certificate[] certificates, String serverOrClient) {
        String principals = UnsafeX509ExtendedTrustManager.extractPrincipals(certificates);
        LOGGER.warn(CERTIFICATE_LOG_MESSAGE, (Object)serverOrClient, (Object)principals);
    }

    private static String extractPrincipals(X509Certificate[] certificates) {
        return Arrays.stream(certificates).map(X509Certificate::getSubjectX500Principal).map(Principal::toString).map(principal -> String.format("{%s}", principal)).collect(Collectors.joining(",", "[", "]"));
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return EMPTY_CERTIFICATES;
    }
}

