/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.model;

import java.util.List;
import javax.net.ssl.X509ExtendedKeyManager;
import nl.altindag.ssl.model.KeyStoreHolder;

public final class IdentityMaterial {
    private X509ExtendedKeyManager keyManager;
    private List<KeyStoreHolder> identities;

    private IdentityMaterial() {
    }

    public X509ExtendedKeyManager getKeyManager() {
        return this.keyManager;
    }

    public List<KeyStoreHolder> getIdentities() {
        return this.identities;
    }

    public static class Builder {
        private X509ExtendedKeyManager keyManager;
        private List<KeyStoreHolder> identities;

        public Builder withKeyManager(X509ExtendedKeyManager keyManager) {
            this.keyManager = keyManager;
            return this;
        }

        public Builder withIdentities(List<KeyStoreHolder> identities) {
            this.identities = identities;
            return this;
        }

        public IdentityMaterial build() {
            IdentityMaterial identityMaterial = new IdentityMaterial();
            identityMaterial.keyManager = this.keyManager;
            identityMaterial.identities = this.identities;
            return identityMaterial;
        }
    }
}

