/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.model;

import java.util.List;
import javax.net.ssl.X509ExtendedTrustManager;
import nl.altindag.ssl.model.KeyStoreHolder;

public final class TrustMaterial {
    private X509ExtendedTrustManager trustManager;
    private List<KeyStoreHolder> trustStores;

    private TrustMaterial() {
    }

    public X509ExtendedTrustManager getTrustManager() {
        return this.trustManager;
    }

    public List<KeyStoreHolder> getTrustStores() {
        return this.trustStores;
    }

    public static class Builder {
        private X509ExtendedTrustManager trustManager;
        private List<KeyStoreHolder> trustStores;

        public Builder withTrustManager(X509ExtendedTrustManager trustManager) {
            this.trustManager = trustManager;
            return this;
        }

        public Builder withTrustStores(List<KeyStoreHolder> trustStores) {
            this.trustStores = trustStores;
            return this;
        }

        public TrustMaterial build() {
            TrustMaterial trustMaterial = new TrustMaterial();
            trustMaterial.trustManager = this.trustManager;
            trustMaterial.trustStores = this.trustStores;
            return trustMaterial;
        }
    }
}

