/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.sslcontext.util;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import nl.altindag.sslcontext.exception.GenericSecurityException;
import nl.altindag.sslcontext.keymanager.CompositeX509ExtendedKeyManager;
import nl.altindag.sslcontext.keymanager.X509KeyManagerWrapper;
import nl.altindag.sslcontext.model.KeyStoreHolder;

public final class KeyManagerUtils {
    private KeyManagerUtils() {
    }

    public static X509ExtendedKeyManager combine(X509ExtendedKeyManager ... keyManagers) {
        return KeyManagerUtils.combine(Arrays.asList(keyManagers));
    }

    public static X509ExtendedKeyManager combine(List<? extends X509ExtendedKeyManager> keyManagers) {
        if (keyManagers.size() == 1) {
            return keyManagers.get(0);
        }
        return CompositeX509ExtendedKeyManager.builder().withKeyManagers(keyManagers).build();
    }

    public static X509ExtendedKeyManager createKeyManager(KeyStoreHolder ... keyStoreHolders) {
        return Arrays.stream(keyStoreHolders).map(keyStoreHolder -> KeyManagerUtils.createKeyManager(keyStoreHolder.getKeyStore(), keyStoreHolder.getKeyPassword())).collect(Collectors.collectingAndThen(Collectors.toList(), KeyManagerUtils::combine));
    }

    public static X509ExtendedKeyManager createKeyManager(KeyStore keyStore, char[] keyPassword) {
        return KeyManagerUtils.createKeyManager(keyStore, keyPassword, KeyManagerFactory.getDefaultAlgorithm());
    }

    public static X509ExtendedKeyManager createKeyManager(KeyStore keyStore, char[] keyPassword, String keyManagerFactoryAlgorithm) {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerFactoryAlgorithm);
            return KeyManagerUtils.createKeyManager(keyStore, keyPassword, keyManagerFactory);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GenericSecurityException(e);
        }
    }

    public static X509ExtendedKeyManager createKeyManager(KeyStore keyStore, char[] keyPassword, String keyManagerFactoryAlgorithm, String securityProviderName) {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerFactoryAlgorithm, securityProviderName);
            return KeyManagerUtils.createKeyManager(keyStore, keyPassword, keyManagerFactory);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new GenericSecurityException(e);
        }
    }

    public static X509ExtendedKeyManager createKeyManager(KeyStore keyStore, char[] keyPassword, String keyManagerFactoryAlgorithm, Provider securityProvider) {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerFactoryAlgorithm, securityProvider);
            return KeyManagerUtils.createKeyManager(keyStore, keyPassword, keyManagerFactory);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GenericSecurityException(e);
        }
    }

    public static X509ExtendedKeyManager createKeyManager(KeyStore keyStore, char[] keyPassword, KeyManagerFactory keyManagerFactory) {
        try {
            keyManagerFactory.init(keyStore, keyPassword);
            return Arrays.stream(keyManagerFactory.getKeyManagers()).filter(keyManager -> keyManager instanceof X509KeyManager).map(keyManager -> (X509KeyManager)keyManager).map(KeyManagerUtils::wrapIfNeeded).collect(Collectors.collectingAndThen(Collectors.toList(), KeyManagerUtils::combine));
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new GenericSecurityException(e);
        }
    }

    public static X509ExtendedKeyManager wrapIfNeeded(X509KeyManager keyManager) {
        if (keyManager instanceof X509ExtendedKeyManager) {
            return (X509ExtendedKeyManager)keyManager;
        }
        return new X509KeyManagerWrapper(keyManager);
    }
}

