/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.sslcontext.trustmanager;

import java.net.Socket;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import nl.altindag.sslcontext.util.TrustManagerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompositeX509ExtendedTrustManager
extends X509ExtendedTrustManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeX509ExtendedTrustManager.class);
    private static final String CERTIFICATE_EXCEPTION_MESSAGE = "None of the TrustManagers trust this certificate chain";
    private static final String CLIENT_CERTIFICATE_LOG_MESSAGE = "Received the following client certificate: [{}]";
    private static final String SERVER_CERTIFICATE_LOG_MESSAGE = "Received the following server certificate: [{}]";
    private final List<? extends X509TrustManager> trustManagers;
    private X509Certificate[] acceptedIssuers;

    public CompositeX509ExtendedTrustManager(List<? extends X509TrustManager> trustManagers) {
        this.trustManagers = Collections.unmodifiableList(trustManagers);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(CLIENT_CERTIFICATE_LOG_MESSAGE, (Object)chain[0].getSubjectDN());
        }
        ArrayList<CertificateException> certificateExceptions = new ArrayList<CertificateException>();
        for (X509TrustManager x509TrustManager : this.trustManagers) {
            try {
                x509TrustManager.checkClientTrusted(chain, authType);
                return;
            }
            catch (CertificateException e) {
                certificateExceptions.add(e);
            }
        }
        CertificateException certificateException = new CertificateException(CERTIFICATE_EXCEPTION_MESSAGE);
        certificateExceptions.forEach(certificateException::addSuppressed);
        throw certificateException;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(CLIENT_CERTIFICATE_LOG_MESSAGE, (Object)chain[0].getSubjectDN());
        }
        ArrayList<CertificateException> certificateExceptions = new ArrayList<CertificateException>();
        for (X509TrustManager x509TrustManager : this.trustManagers) {
            try {
                if (x509TrustManager instanceof X509ExtendedTrustManager) {
                    ((X509ExtendedTrustManager)x509TrustManager).checkClientTrusted(chain, authType, socket);
                    return;
                }
                x509TrustManager.checkClientTrusted(chain, authType);
                return;
            }
            catch (CertificateException e) {
                certificateExceptions.add(e);
            }
        }
        CertificateException certificateException = new CertificateException(CERTIFICATE_EXCEPTION_MESSAGE);
        certificateExceptions.forEach(certificateException::addSuppressed);
        throw certificateException;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(CLIENT_CERTIFICATE_LOG_MESSAGE, (Object)chain[0].getSubjectDN());
        }
        ArrayList<CertificateException> certificateExceptions = new ArrayList<CertificateException>();
        for (X509TrustManager x509TrustManager : this.trustManagers) {
            try {
                if (x509TrustManager instanceof X509ExtendedTrustManager) {
                    ((X509ExtendedTrustManager)x509TrustManager).checkClientTrusted(chain, authType, sslEngine);
                    return;
                }
                x509TrustManager.checkClientTrusted(chain, authType);
                return;
            }
            catch (CertificateException e) {
                certificateExceptions.add(e);
            }
        }
        CertificateException certificateException = new CertificateException(CERTIFICATE_EXCEPTION_MESSAGE);
        certificateExceptions.forEach(certificateException::addSuppressed);
        throw certificateException;
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(SERVER_CERTIFICATE_LOG_MESSAGE, (Object)chain[0].getSubjectDN());
        }
        ArrayList<CertificateException> certificateExceptions = new ArrayList<CertificateException>();
        for (X509TrustManager x509TrustManager : this.trustManagers) {
            try {
                x509TrustManager.checkServerTrusted(chain, authType);
                return;
            }
            catch (CertificateException e) {
                certificateExceptions.add(e);
            }
        }
        CertificateException certificateException = new CertificateException(CERTIFICATE_EXCEPTION_MESSAGE);
        certificateExceptions.forEach(certificateException::addSuppressed);
        throw certificateException;
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(SERVER_CERTIFICATE_LOG_MESSAGE, (Object)chain[0].getSubjectDN());
        }
        ArrayList<CertificateException> certificateExceptions = new ArrayList<CertificateException>();
        for (X509TrustManager x509TrustManager : this.trustManagers) {
            try {
                if (x509TrustManager instanceof X509ExtendedTrustManager) {
                    ((X509ExtendedTrustManager)x509TrustManager).checkServerTrusted(chain, authType, socket);
                    return;
                }
                x509TrustManager.checkServerTrusted(chain, authType);
                return;
            }
            catch (CertificateException e) {
                certificateExceptions.add(e);
            }
        }
        CertificateException certificateException = new CertificateException(CERTIFICATE_EXCEPTION_MESSAGE);
        certificateExceptions.forEach(certificateException::addSuppressed);
        throw certificateException;
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(SERVER_CERTIFICATE_LOG_MESSAGE, (Object)chain[0].getSubjectDN());
        }
        ArrayList<CertificateException> certificateExceptions = new ArrayList<CertificateException>();
        for (X509TrustManager x509TrustManager : this.trustManagers) {
            try {
                if (x509TrustManager instanceof X509ExtendedTrustManager) {
                    ((X509ExtendedTrustManager)x509TrustManager).checkServerTrusted(chain, authType, sslEngine);
                    return;
                }
                x509TrustManager.checkServerTrusted(chain, authType);
                return;
            }
            catch (CertificateException e) {
                certificateExceptions.add(e);
            }
        }
        CertificateException certificateException = new CertificateException(CERTIFICATE_EXCEPTION_MESSAGE);
        certificateExceptions.forEach(certificateException::addSuppressed);
        throw certificateException;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        if (Objects.isNull(this.acceptedIssuers)) {
            this.acceptedIssuers = (X509Certificate[])this.trustManagers.stream().map(X509TrustManager::getAcceptedIssuers).flatMap(Arrays::stream).distinct().toArray(X509Certificate[]::new);
        }
        return this.acceptedIssuers;
    }

    public int size() {
        return this.trustManagers.size();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<X509TrustManager> trustManagers = new ArrayList<X509TrustManager>();

        public <T extends X509TrustManager> Builder withTrustManagers(T ... trustManagers) {
            return this.withTrustManagers(Arrays.asList(trustManagers));
        }

        public Builder withTrustManagers(List<? extends X509TrustManager> trustManagers) {
            this.trustManagers.addAll(trustManagers);
            return this;
        }

        public <T extends KeyStore> Builder withTrustStores(T ... trustStores) {
            return this.withTrustStores(Arrays.asList(trustStores));
        }

        public Builder withTrustStores(List<? extends KeyStore> trustStores) {
            for (KeyStore keyStore : trustStores) {
                this.trustManagers.add(TrustManagerUtils.createTrustManager(keyStore));
            }
            return this;
        }

        public <T extends KeyStore> Builder withTrustStore(T trustStore) {
            this.trustManagers.add(TrustManagerUtils.createTrustManager(trustStore));
            return this;
        }

        public <T extends KeyStore> Builder withTrustStore(T trustStore, String trustManagerAlgorithm) {
            this.trustManagers.add(TrustManagerUtils.createTrustManager(trustStore, trustManagerAlgorithm));
            return this;
        }

        public CompositeX509ExtendedTrustManager build() {
            return new CompositeX509ExtendedTrustManager(this.trustManagers);
        }
    }
}

