/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.sslcontext.trustmanager;

import com.google.common.collect.ImmutableList;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.X509TrustManager;
import nl.altindag.sslcontext.util.TrustManagerUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompositeX509TrustManager
implements X509TrustManager {
    private static final Logger LOGGER = LogManager.getLogger(CompositeX509TrustManager.class);
    private final List<? extends X509TrustManager> trustManagers;
    private X509Certificate[] acceptedIssuers;

    public CompositeX509TrustManager(List<? extends X509TrustManager> trustManagers) {
        this.trustManagers = ImmutableList.copyOf(trustManagers);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received the following client certificate: [{}]", (Object)chain[0].getSubjectDN());
        }
        ArrayList<CertificateException> certificateExceptions = new ArrayList<CertificateException>();
        for (X509TrustManager x509TrustManager : this.trustManagers) {
            try {
                x509TrustManager.checkClientTrusted(chain, authType);
                return;
            }
            catch (CertificateException e) {
                certificateExceptions.add(e);
            }
        }
        CertificateException certificateException = new CertificateException("None of the TrustManagers trust this certificate chain");
        certificateExceptions.forEach(certificateException::addSuppressed);
        throw certificateException;
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received the following server certificate: [{}]", (Object)chain[0].getSubjectDN());
        }
        ArrayList<CertificateException> certificateExceptions = new ArrayList<CertificateException>();
        for (X509TrustManager x509TrustManager : this.trustManagers) {
            try {
                x509TrustManager.checkServerTrusted(chain, authType);
                return;
            }
            catch (CertificateException e) {
                certificateExceptions.add(e);
            }
        }
        CertificateException certificateException = new CertificateException("None of the TrustManagers trust this certificate chain");
        certificateExceptions.forEach(certificateException::addSuppressed);
        throw certificateException;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        if (Objects.isNull(this.acceptedIssuers)) {
            this.acceptedIssuers = (X509Certificate[])this.trustManagers.stream().map(X509TrustManager::getAcceptedIssuers).flatMap(Arrays::stream).distinct().toArray(X509Certificate[]::new);
        }
        return this.acceptedIssuers;
    }

    public X509TrustManager[] getTrustManagers() {
        return (X509TrustManager[])this.trustManagers.stream().toArray(X509TrustManager[]::new);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<X509TrustManager> trustManagers = new ArrayList<X509TrustManager>();

        public <T extends X509TrustManager> Builder withTrustManagers(T ... trustManagers) {
            return this.withTrustManagers(Arrays.asList(trustManagers));
        }

        public Builder withTrustManagers(List<? extends X509TrustManager> trustManagers) {
            this.trustManagers.addAll(trustManagers);
            return this;
        }

        public <T extends KeyStore> Builder withTrustStores(T ... trustStores) {
            return this.withTrustStores(Arrays.asList(trustStores));
        }

        public Builder withTrustStores(List<? extends KeyStore> trustStores) {
            for (KeyStore keyStore : trustStores) {
                this.trustManagers.add(TrustManagerUtils.createTrustManager(keyStore));
            }
            return this;
        }

        public <T extends KeyStore> Builder withTrustStore(T trustStore, String trustManagerAlgorithm) {
            this.trustManagers.add(TrustManagerUtils.createTrustManager(trustStore, trustManagerAlgorithm));
            return this;
        }

        public CompositeX509TrustManager build() {
            return new CompositeX509TrustManager(this.trustManagers);
        }
    }
}

