/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.sslcontext.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Objects;

public final class KeystoreUtils {
    private KeystoreUtils() {
    }

    public static KeyStore loadKeyStore(String keystorePath, char[] keystorePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        return KeystoreUtils.loadKeyStore(keystorePath, keystorePassword, KeyStore.getDefaultType());
    }

    public static KeyStore loadKeyStore(String keystorePath, char[] keystorePassword, String keystoreType) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        try (InputStream keystoreInputStream = KeystoreUtils.class.getClassLoader().getResourceAsStream(keystorePath);){
            KeyStore keyStore = KeystoreUtils.loadKeyStore(keystoreInputStream, keystorePassword, keystoreType);
            return keyStore;
        }
    }

    public static KeyStore loadKeyStore(Path keystorePath, char[] keystorePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        return KeystoreUtils.loadKeyStore(keystorePath, keystorePassword, KeyStore.getDefaultType());
    }

    public static KeyStore loadKeyStore(Path keystorePath, char[] keystorePassword, String keystoreType) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        try (InputStream keystoreInputStream = Files.newInputStream(keystorePath, StandardOpenOption.READ);){
            KeyStore keyStore = KeystoreUtils.loadKeyStore(keystoreInputStream, keystorePassword, keystoreType);
            return keyStore;
        }
    }

    private static KeyStore loadKeyStore(InputStream keystoreInputStream, char[] keystorePassword, String keystoreType) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        if (Objects.isNull(keystoreInputStream)) {
            throw new IOException("Could not find the keystore file");
        }
        KeyStore keystore = KeyStore.getInstance(keystoreType);
        keystore.load(keystoreInputStream, keystorePassword);
        return keystore;
    }
}

