/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.sslcontext;

import java.io.IOException;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import nl.altindag.sslcontext.exception.GenericKeyStoreException;
import nl.altindag.sslcontext.exception.GenericSSLContextException;
import nl.altindag.sslcontext.trustmanager.CompositeX509TrustManager;
import nl.altindag.sslcontext.trustmanager.TrustManagerFactoryWrapper;
import nl.altindag.sslcontext.trustmanager.UnsafeTrustManager;
import nl.altindag.sslcontext.util.KeystoreUtils;
import nl.altindag.sslcontext.util.TrustManagerUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;

public class SSLContextHelper {
    private KeyStore identity;
    private char[] identityPassword;
    private KeyStore trustStore;
    private char[] trustStorePassword;
    private boolean securityEnabled;
    private boolean oneWayAuthenticationEnabled;
    private boolean twoWayAuthenticationEnabled;
    private boolean includeDefaultJdkTrustStore;
    private boolean trustingAllCertificatesWithoutValidationEnabled;
    private String protocol;
    private SSLContext sslContext;
    private CompositeX509TrustManager trustManager;
    private TrustManagerFactory trustManagerFactory;
    private KeyManagerFactory keyManagerFactory;
    private HostnameVerifier hostnameVerifier;

    private SSLContextHelper() {
    }

    private void createSSLContextWithTrustStore() {
        try {
            this.createSSLContext(null, this.createTrustManagerFactory().getTrustManagers());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new GenericSSLContextException(e);
        }
    }

    private void createSSLContextWithKeyStoreAndTrustStore() {
        try {
            this.createSSLContext(this.createKeyManagerFactory().getKeyManagers(), this.createTrustManagerFactory().getTrustManagers());
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new GenericSSLContextException(e);
        }
    }

    private void createSSLContext(KeyManager[] keyManagers, TrustManager[] trustManagers) throws NoSuchAlgorithmException, KeyManagementException {
        this.sslContext = SSLContext.getInstance(this.protocol);
        this.sslContext.init(keyManagers, trustManagers, null);
    }

    private KeyManagerFactory createKeyManagerFactory() throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        this.keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        this.keyManagerFactory.init(this.identity, this.identityPassword);
        return this.keyManagerFactory;
    }

    private TrustManagerFactory createTrustManagerFactory() {
        CompositeX509TrustManager.Builder trustManagerBuilder = CompositeX509TrustManager.builder();
        if (this.trustingAllCertificatesWithoutValidationEnabled) {
            trustManagerBuilder.withTrustManager(UnsafeTrustManager.INSTANCE);
        }
        if (this.includeDefaultJdkTrustStore) {
            trustManagerBuilder.withTrustManager(TrustManagerUtils.createTrustManagerWithJdkTrustedCertificates());
        }
        this.trustManager = Objects.isNull(this.trustStore) ? trustManagerBuilder.build() : trustManagerBuilder.withTrustStore(this.trustStore, TrustManagerFactory.getDefaultAlgorithm()).build();
        this.trustManagerFactory = new TrustManagerFactoryWrapper(this.trustManager);
        return this.trustManagerFactory;
    }

    public KeyStore getIdentity() {
        return this.identity;
    }

    public char[] getIdentityPassword() {
        return this.identityPassword;
    }

    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    public char[] getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public boolean isOneWayAuthenticationEnabled() {
        return this.oneWayAuthenticationEnabled;
    }

    public boolean isTwoWayAuthenticationEnabled() {
        return this.twoWayAuthenticationEnabled;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public KeyManagerFactory getKeyManagerFactory() {
        return this.keyManagerFactory;
    }

    public X509TrustManager getX509TrustManager() {
        return this.trustManager;
    }

    public TrustManagerFactory getTrustManagerFactory() {
        return this.trustManagerFactory;
    }

    public X509Certificate[] getTrustedX509Certificate() {
        return Optional.ofNullable(this.trustManager).map(X509TrustManager::getAcceptedIssuers).orElse(new X509Certificate[0]);
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public static Builder builder() {
        return new Builder();
    }

    static /* synthetic */ char[] access$802(SSLContextHelper x0, char[] x1) {
        x0.trustStorePassword = x1;
        return x1;
    }

    static /* synthetic */ char[] access$1202(SSLContextHelper x0, char[] x1) {
        x0.identityPassword = x1;
        return x1;
    }

    public static class Builder {
        private static final String TRUST_STORE_VALIDATION_EXCEPTION_MESSAGE = "TrustStore details are empty, which are required to be present when SSL/TLS is enabled";
        private static final String TRUST_STRATEGY_VALIDATION_EXCEPTION_MESSAGE = "Trust strategy is missing. Please validate if the TrustStore is present, or default including the JDK trustStore is enabled or trusting all certificates without validation is enabled";
        private static final String IDENTITY_VALIDATION_EXCEPTION_MESSAGE = "Identity details are empty, which are required to be present when SSL/TLS is enabled";
        private static final String KEY_STORE_LOADING_EXCEPTION = "Failed to load the keystore";
        private String protocol = "TLSv1.2";
        private boolean hostnameVerifierEnabled = true;
        private KeyStore identity;
        private char[] identityPassword;
        private KeyStore trustStore;
        private char[] trustStorePassword;
        private boolean oneWayAuthenticationEnabled;
        private boolean twoWayAuthenticationEnabled;
        private boolean includeDefaultJdkTrustStore = false;
        private boolean trustingAllCertificatesWithoutValidationEnabled = false;

        public Builder withDefaultJdkTrustStore() {
            this.includeDefaultJdkTrustStore = true;
            this.oneWayAuthenticationEnabled = true;
            return this;
        }

        public Builder withTrustStore(String trustStorePath, char[] trustStorePassword) {
            return this.withTrustStore(trustStorePath, trustStorePassword, KeyStore.getDefaultType());
        }

        public Builder withTrustStore(String trustStorePath, char[] trustStorePassword, String trustStoreType) {
            if (StringUtils.isBlank((CharSequence)trustStorePath) || ArrayUtils.isEmpty((char[])trustStorePassword)) {
                throw new GenericKeyStoreException(TRUST_STORE_VALIDATION_EXCEPTION_MESSAGE);
            }
            try {
                this.trustStore = KeystoreUtils.loadKeyStore(trustStorePath, trustStorePassword, trustStoreType);
                this.trustStorePassword = trustStorePassword;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new GenericKeyStoreException(KEY_STORE_LOADING_EXCEPTION, e);
            }
            this.oneWayAuthenticationEnabled = true;
            return this;
        }

        public Builder withTrustStore(Path trustStorePath, char[] trustStorePassword) {
            return this.withTrustStore(trustStorePath, trustStorePassword, KeyStore.getDefaultType());
        }

        public Builder withTrustStore(Path trustStorePath, char[] trustStorePassword, String trustStoreType) {
            if (Objects.isNull(trustStorePath) || ArrayUtils.isEmpty((char[])trustStorePassword) || StringUtils.isBlank((CharSequence)trustStoreType)) {
                throw new GenericKeyStoreException(TRUST_STORE_VALIDATION_EXCEPTION_MESSAGE);
            }
            try {
                this.trustStore = KeystoreUtils.loadKeyStore(trustStorePath, trustStorePassword, trustStoreType);
                this.trustStorePassword = trustStorePassword;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new GenericKeyStoreException(KEY_STORE_LOADING_EXCEPTION, e);
            }
            this.oneWayAuthenticationEnabled = true;
            return this;
        }

        public Builder withTrustStore(KeyStore trustStore, char[] trustStorePassword) {
            this.validateKeyStore(trustStore, trustStorePassword, TRUST_STORE_VALIDATION_EXCEPTION_MESSAGE);
            this.trustStore = trustStore;
            this.trustStorePassword = trustStorePassword;
            this.oneWayAuthenticationEnabled = true;
            return this;
        }

        public Builder withIdentity(String identityPath, char[] identityPassword) {
            return this.withIdentity(identityPath, identityPassword, KeyStore.getDefaultType());
        }

        public Builder withIdentity(String identityPath, char[] identityPassword, String identityType) {
            if (StringUtils.isBlank((CharSequence)identityPath) || ArrayUtils.isEmpty((char[])identityPassword) || StringUtils.isBlank((CharSequence)identityType)) {
                throw new GenericKeyStoreException(IDENTITY_VALIDATION_EXCEPTION_MESSAGE);
            }
            try {
                this.identity = KeystoreUtils.loadKeyStore(identityPath, identityPassword, identityType);
                this.identityPassword = identityPassword;
                this.twoWayAuthenticationEnabled = true;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new GenericKeyStoreException(KEY_STORE_LOADING_EXCEPTION, e);
            }
            return this;
        }

        public Builder withIdentity(Path identityPath, char[] identityPassword) {
            return this.withIdentity(identityPath, identityPassword, KeyStore.getDefaultType());
        }

        public Builder withIdentity(Path identityPath, char[] identityPassword, String identityType) {
            if (Objects.isNull(identityPath) || ArrayUtils.isEmpty((char[])identityPassword) || StringUtils.isBlank((CharSequence)identityType)) {
                throw new GenericKeyStoreException(IDENTITY_VALIDATION_EXCEPTION_MESSAGE);
            }
            try {
                this.identity = KeystoreUtils.loadKeyStore(identityPath, identityPassword, identityType);
                this.identityPassword = identityPassword;
                this.twoWayAuthenticationEnabled = true;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new GenericKeyStoreException(KEY_STORE_LOADING_EXCEPTION, e);
            }
            return this;
        }

        public Builder withIdentity(KeyStore identity, char[] identityPassword) {
            this.validateKeyStore(identity, identityPassword, IDENTITY_VALIDATION_EXCEPTION_MESSAGE);
            this.identity = identity;
            this.identityPassword = identityPassword;
            this.twoWayAuthenticationEnabled = true;
            return this;
        }

        private void validateKeyStore(KeyStore keyStore, char[] keyStorePassword, String exceptionMessage) {
            if (Objects.isNull(keyStore) || ArrayUtils.isEmpty((char[])keyStorePassword)) {
                throw new GenericKeyStoreException(exceptionMessage);
            }
        }

        public Builder withHostnameVerifierEnabled(boolean hostnameVerifierEnabled) {
            this.hostnameVerifierEnabled = hostnameVerifierEnabled;
            return this;
        }

        public Builder withProtocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder withTrustingAllCertificatesWithoutValidation() {
            this.trustingAllCertificatesWithoutValidationEnabled = true;
            this.oneWayAuthenticationEnabled = true;
            return this;
        }

        public SSLContextHelper build() {
            SSLContextHelper sslContextHelper = new SSLContextHelper();
            if (!this.oneWayAuthenticationEnabled && !this.twoWayAuthenticationEnabled) {
                return sslContextHelper;
            }
            this.validateTrustStore();
            this.buildHostnameVerifier(sslContextHelper);
            sslContextHelper.protocol = this.protocol;
            sslContextHelper.securityEnabled = true;
            sslContextHelper.includeDefaultJdkTrustStore = this.includeDefaultJdkTrustStore;
            sslContextHelper.trustingAllCertificatesWithoutValidationEnabled = this.trustingAllCertificatesWithoutValidationEnabled;
            if (this.twoWayAuthenticationEnabled) {
                this.oneWayAuthenticationEnabled = false;
            }
            this.buildSLLContextForOneWayAuthenticationIfEnabled(sslContextHelper);
            this.buildSLLContextForTwoWayAuthenticationIfEnabled(sslContextHelper);
            return sslContextHelper;
        }

        private void buildHostnameVerifier(SSLContextHelper sslContextHelper) {
            if (this.hostnameVerifierEnabled) {
                sslContextHelper.hostnameVerifier = (HostnameVerifier)new DefaultHostnameVerifier();
            } else {
                sslContextHelper.hostnameVerifier = (HostnameVerifier)new NoopHostnameVerifier();
            }
        }

        private void buildSLLContextForOneWayAuthenticationIfEnabled(SSLContextHelper sslContextHelper) {
            if (this.oneWayAuthenticationEnabled) {
                sslContextHelper.oneWayAuthenticationEnabled = true;
                sslContextHelper.trustStore = this.trustStore;
                SSLContextHelper.access$802(sslContextHelper, this.trustStorePassword);
                sslContextHelper.createSSLContextWithTrustStore();
            }
        }

        private void buildSLLContextForTwoWayAuthenticationIfEnabled(SSLContextHelper sslContextHelper) {
            if (this.twoWayAuthenticationEnabled) {
                sslContextHelper.twoWayAuthenticationEnabled = true;
                sslContextHelper.identity = this.identity;
                SSLContextHelper.access$1202(sslContextHelper, this.identityPassword);
                sslContextHelper.trustStore = this.trustStore;
                SSLContextHelper.access$802(sslContextHelper, this.trustStorePassword);
                sslContextHelper.createSSLContextWithKeyStoreAndTrustStore();
            }
        }

        private void validateTrustStore() {
            if (Objects.isNull(this.trustStore) && !this.includeDefaultJdkTrustStore && !this.trustingAllCertificatesWithoutValidationEnabled) {
                throw new GenericKeyStoreException(TRUST_STRATEGY_VALIDATION_EXCEPTION_MESSAGE);
            }
        }
    }
}

