/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.util;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.altindag.ssl.exception.GenericIOException;
import nl.altindag.ssl.util.CertificateUtils;
import nl.altindag.ssl.util.KeyStoreUtils;
import nl.altindag.sude.Logger;
import nl.altindag.sude.LoggerFactory;

abstract class OSCertificateUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OSCertificateUtils.class);

    OSCertificateUtils() {
    }

    abstract List<KeyStore> getTrustStores();

    List<Certificate> getCertificates(List<Path> certificatePaths) {
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        try {
            for (Path path : certificatePaths) {
                if (!Files.exists(path, new LinkOption[0])) continue;
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    List<Certificate> certs = this.loadCertificate(path);
                    certificates.addAll(certs);
                    continue;
                }
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                Stream<Path> files = Files.walk(path, 1, FileVisitOption.FOLLOW_LINKS);
                try {
                    List certs = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).flatMap(file -> this.loadCertificate((Path)file).stream()).collect(Collectors.toList());
                    certificates.addAll(certs);
                }
                finally {
                    if (files == null) continue;
                    files.close();
                }
            }
            return Collections.unmodifiableList(certificates);
        }
        catch (IOException e) {
            throw new GenericIOException(e);
        }
    }

    List<Certificate> loadCertificate(Path path) {
        try {
            return CertificateUtils.loadCertificate(path);
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    List<Path> findPathsWithSamePrefix(String filenamePrefix, Path rootPath) {
        List<Path> list;
        block8: {
            Stream<Path> files = Files.list(rootPath);
            try {
                list = files.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().startsWith(filenamePrefix)).collect(Collectors.toList());
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return Collections.emptyList();
                }
            }
            files.close();
        }
        return list;
    }

    Optional<KeyStore> createKeyStoreIfAvailable(String keyStoreType, char[] keyStorePassword) {
        try {
            KeyStore keyStore = KeyStoreUtils.createKeyStore(keyStoreType, keyStorePassword);
            if (LOGGER.isDebugEnabled()) {
                int totalTrustedCertificates = KeyStoreUtils.countAmountOfTrustMaterial(keyStore);
                LOGGER.debug(String.format("Successfully loaded KeyStore of the type [%s] having [%d] entries", keyStoreType, totalTrustedCertificates));
            }
            return Optional.of(keyStore);
        }
        catch (Exception ignored) {
            LOGGER.debug(String.format("Failed to load KeyStore of the type [%s]", keyStoreType));
            return Optional.empty();
        }
    }
}

