/*
 * Decompiled with CFR 0.152.
 */
package org.mediasoup.droid;

import java.util.List;
import org.mediasoup.droid.DataProducer;
import org.mediasoup.droid.MediasoupException;
import org.mediasoup.droid.Producer;
import org.mediasoup.droid.Transport;
import org.webrtc.CalledByNative;
import org.webrtc.MediaStreamTrack;
import org.webrtc.RTCUtils;
import org.webrtc.RtpParameters;

public class SendTransport
extends Transport {
    private long mNativeTransport;

    @CalledByNative
    public SendTransport(long nativeTransport) {
        this.mNativeTransport = nativeTransport;
    }

    public void dispose() {
        this.checkTransportExists();
        SendTransport.nativeFreeTransport(this.mNativeTransport);
        this.mNativeTransport = 0L;
    }

    private void checkTransportExists() {
        if (this.mNativeTransport == 0L) {
            throw new IllegalStateException("SendTransport has been disposed.");
        }
    }

    @Override
    public long getNativeTransport() {
        return SendTransport.nativeGetNativeTransport(this.mNativeTransport);
    }

    public Producer produce(Producer.Listener listener, MediaStreamTrack track, List<RtpParameters.Encoding> encodings, String codecOptions, String codec) throws MediasoupException {
        return this.produce(listener, track, encodings, codecOptions, codec, null);
    }

    public Producer produce(Producer.Listener listener, MediaStreamTrack track, List<RtpParameters.Encoding> encodings, String codecOptions, String codec, String appData) throws MediasoupException {
        this.checkTransportExists();
        long nativeTrack = RTCUtils.getNativeMediaStreamTrack(track);
        RtpParameters.Encoding[] pEncodings = null;
        if (encodings != null && !encodings.isEmpty()) {
            pEncodings = new RtpParameters.Encoding[encodings.size()];
            encodings.toArray(pEncodings);
        }
        return SendTransport.nativeProduce(this.mNativeTransport, listener, nativeTrack, pEncodings, codecOptions, codec, appData);
    }

    public DataProducer produceData(DataProducer.Listener listener) {
        return SendTransport.nativeProduceData(this.mNativeTransport, listener, null, null, true, 0, 0, null);
    }

    public DataProducer produceData(DataProducer.Listener listener, String label, String protocol, boolean ordered, int maxRetransmits, int maxPacketLifeTime, String appData) {
        return SendTransport.nativeProduceData(this.mNativeTransport, listener, label, protocol, ordered, maxRetransmits, maxPacketLifeTime, appData);
    }

    private static native long nativeGetNativeTransport(long var0);

    private static native Producer nativeProduce(long var0, Producer.Listener var2, long var3, RtpParameters.Encoding[] var5, String var6, String var7, String var8);

    private static native DataProducer nativeProduceData(long var0, DataProducer.Listener var2, String var3, String var4, boolean var5, int var6, int var7, String var8);

    private static native void nativeFreeTransport(long var0);

    public static interface Listener
    extends Transport.Listener {
        @CalledByNative(value="Listener")
        public String onProduce(Transport var1, String var2, String var3, String var4);

        @CalledByNative(value="Listener")
        public String onProduceData(Transport var1, String var2, String var3, String var4, String var5);
    }
}

