/*
 * Decompiled with CFR 0.152.
 */
package org.mediasoup.droid;

import org.mediasoup.droid.Consumer;
import org.mediasoup.droid.DataConsumer;
import org.mediasoup.droid.MediasoupException;
import org.mediasoup.droid.Transport;
import org.webrtc.CalledByNative;

public class RecvTransport
extends Transport {
    private long mNativeTransport;

    @CalledByNative
    public RecvTransport(long nativeTransport) {
        this.mNativeTransport = nativeTransport;
    }

    public void dispose() {
        this.checkTransportExists();
        RecvTransport.nativeFreeTransport(this.mNativeTransport);
        this.mNativeTransport = 0L;
    }

    @Override
    public long getNativeTransport() {
        return RecvTransport.nativeGetNativeTransport(this.mNativeTransport);
    }

    private void checkTransportExists() {
        if (this.mNativeTransport == 0L) {
            throw new IllegalStateException("RecvTransport has been disposed.");
        }
    }

    public Consumer consume(Consumer.Listener listener, String id, String producerId, String kind, String rtpParameters) throws MediasoupException {
        return this.consume(listener, id, producerId, kind, rtpParameters, null);
    }

    public Consumer consume(Consumer.Listener listener, String id, String producerId, String kind, String rtpParameters, String appData) throws MediasoupException {
        this.checkTransportExists();
        return RecvTransport.nativeConsume(this.mNativeTransport, listener, id, producerId, kind, rtpParameters, appData);
    }

    public DataConsumer consumeData(DataConsumer.Listener listener, String id, String producerId, long streamId, String label) {
        return this.consumeData(listener, id, producerId, streamId, label, null, null);
    }

    public DataConsumer consumeData(DataConsumer.Listener listener, String id, String producerId, long streamId, String label, String protocol, String appData) {
        this.checkTransportExists();
        return RecvTransport.nativeConsumeData(this.mNativeTransport, listener, id, producerId, streamId, label, protocol, appData);
    }

    private static native long nativeGetNativeTransport(long var0);

    private static native Consumer nativeConsume(long var0, Consumer.Listener var2, String var3, String var4, String var5, String var6, String var7);

    private static native DataConsumer nativeConsumeData(long var0, DataConsumer.Listener var2, String var3, String var4, long var5, String var7, String var8, String var9);

    private static native void nativeFreeTransport(long var0);

    public static interface Listener
    extends Transport.Listener {
    }
}

