/*
 * Decompiled with CFR 0.152.
 */
package org.mediasoup.droid;

import androidx.annotation.Nullable;
import org.mediasoup.droid.MediasoupException;
import org.webrtc.CalledByNative;
import org.webrtc.MediaStreamTrack;
import org.webrtc.RTCUtils;

public class Producer {
    private final long mNativeProducer;
    @Nullable
    private MediaStreamTrack mCachedTrack;

    @CalledByNative
    public Producer(long nativeProducer) {
        this.mNativeProducer = nativeProducer;
        long nativeTrack = Producer.nativeGetTrack(this.mNativeProducer);
        this.mCachedTrack = RTCUtils.createMediaStreamTrack(nativeTrack);
    }

    public String getId() {
        return Producer.nativeGetId(this.mNativeProducer);
    }

    public boolean isClosed() {
        return Producer.nativeIsClosed(this.mNativeProducer);
    }

    public String getKind() {
        return Producer.nativeGetKind(this.mNativeProducer);
    }

    public MediaStreamTrack getTrack() {
        return this.mCachedTrack;
    }

    public boolean isPaused() {
        return Producer.nativeIsPaused(this.mNativeProducer);
    }

    public int getMaxSpatialLayer() {
        return Producer.nativeGetMaxSpatialLayer(this.mNativeProducer);
    }

    public String getAppData() {
        return Producer.nativeGetAppData(this.mNativeProducer);
    }

    public String getRtpParameters() {
        return Producer.nativeGetRtpParameters(this.mNativeProducer);
    }

    public void resume() {
        Producer.nativeResume(this.mNativeProducer);
    }

    public void setMaxSpatialLayer(int layer) throws MediasoupException {
        Producer.nativeSetMaxSpatialLayer(this.mNativeProducer, layer);
    }

    public void pause() {
        Producer.nativePause(this.mNativeProducer);
    }

    public void replaceTrack(MediaStreamTrack track) throws MediasoupException {
        long nativeMediaStreamTrack = RTCUtils.getNativeMediaStreamTrack(track);
        Producer.nativeReplaceTrack(this.mNativeProducer, nativeMediaStreamTrack);
        this.mCachedTrack = track;
    }

    public String getStats() throws MediasoupException {
        return Producer.nativeGetStats(this.mNativeProducer);
    }

    public void close() {
        Producer.nativeClose(this.mNativeProducer);
    }

    private static native String nativeGetId(long var0);

    private static native boolean nativeIsClosed(long var0);

    private static native String nativeGetKind(long var0);

    private static native long nativeGetTrack(long var0);

    private static native boolean nativeIsPaused(long var0);

    private static native int nativeGetMaxSpatialLayer(long var0);

    private static native String nativeGetAppData(long var0);

    private static native String nativeGetRtpParameters(long var0);

    private static native String nativeGetStats(long var0);

    private static native void nativeResume(long var0);

    private static native void nativeSetMaxSpatialLayer(long var0, int var2);

    private static native void nativePause(long var0);

    private static native void nativeReplaceTrack(long var0, long var2);

    private static native void nativeClose(long var0);

    public static interface Listener {
        @CalledByNative(value="Listener")
        public void onTransportClose(Producer var1);
    }
}

