/*
 * Decompiled with CFR 0.152.
 */
package org.mediasoup.droid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mediasoup.droid.MediasoupException;
import org.webrtc.CalledByNative;
import org.webrtc.DataChannel;
import org.webrtc.IceCandidate;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.MediaStreamTrack;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.RTCUtils;
import org.webrtc.RtpReceiver;
import org.webrtc.RtpSender;
import org.webrtc.RtpTransceiver;
import org.webrtc.SessionDescription;

public class PeerConnection {
    private final Options mOptions;
    private long mNativePeerConnection;
    private List<RtpSender> mSenders = new ArrayList<RtpSender>();
    private List<RtpTransceiver> mTransceivers = new ArrayList<RtpTransceiver>();

    public PeerConnection(PrivateListener listener, Options options) {
        if (listener == null) {
            throw new IllegalArgumentException("given listener is null");
        }
        this.mOptions = new Options();
        this.mOptions.mRTCConfig = options != null && options.mRTCConfig != null ? options.mRTCConfig : new PeerConnection.RTCConfiguration(new ArrayList());
        if (options != null && options.mFactory != null) {
            this.mOptions.mFactory = options.mFactory;
        }
        this.mNativePeerConnection = PeerConnection.nativeNewPeerConnection(listener, this.mOptions.mRTCConfig, this.mOptions.mFactory != null ? this.mOptions.mFactory.getNativePeerConnectionFactory() : 0L);
    }

    public void dispose() {
        this.close();
        for (RtpSender sender : this.mSenders) {
            sender.dispose();
        }
        this.mSenders.clear();
        for (RtpTransceiver transceiver : this.mTransceivers) {
            transceiver.dispose();
        }
        this.mTransceivers.clear();
        PeerConnection.nativeFreeOwnedPeerConnection(this.mNativePeerConnection);
        this.mNativePeerConnection = 0L;
    }

    public PeerConnection.RTCConfiguration getConfiguration() {
        return this.mOptions.mRTCConfig;
    }

    public boolean setConfiguration(PeerConnection.RTCConfiguration config) {
        return this.nativeSetConfiguration(config);
    }

    public String createOffer(MediaConstraints constraints) {
        return this.nativeCreateOffer(constraints);
    }

    public String createAnswer(MediaConstraints constraints) throws MediasoupException {
        return this.nativeCreateAnswer(constraints);
    }

    public void setLocalDescription(SessionDescription sessionDescription) throws MediasoupException {
        if (sessionDescription == null) {
            throw new IllegalArgumentException("given sessionDescription is null");
        }
        this.nativeSetLocalDescription(sessionDescription.type.ordinal(), sessionDescription.description);
    }

    public void setRemoteDescription(SessionDescription sessionDescription) throws MediasoupException {
        if (sessionDescription == null) {
            throw new IllegalArgumentException("given sessionDescription is null");
        }
        this.nativeSetRemoteDescription(sessionDescription.type.ordinal(), sessionDescription.description);
    }

    public String getLocalDescription() {
        return this.nativeGetLocalDescription();
    }

    public String getRemoteDescription() {
        return this.nativeGetRemoteDescription();
    }

    public List<RtpTransceiver> getTransceivers() {
        for (RtpTransceiver transceiver : this.mTransceivers) {
            transceiver.dispose();
        }
        this.mTransceivers = this.nativeGetTransceivers();
        return Collections.unmodifiableList(this.mTransceivers);
    }

    public RtpTransceiver addTransceiver(MediaStreamTrack.MediaType mediaType) {
        if (mediaType == null) {
            throw new NullPointerException("No MediaType specified for addTransceiver.");
        }
        RtpTransceiver newTransceiver = this.nativeAddTransceiverOfType(mediaType);
        if (newTransceiver == null) {
            throw new IllegalStateException("C++ addTransceiver failed.");
        }
        this.mTransceivers.add(newTransceiver);
        return newTransceiver;
    }

    public RtpTransceiver addTransceiver(MediaStreamTrack track) {
        return this.addTransceiver(track, new RtpTransceiver.RtpTransceiverInit());
    }

    public RtpTransceiver addTransceiver(MediaStreamTrack track, RtpTransceiver.RtpTransceiverInit init) {
        RtpTransceiver newTransceiver;
        if (track == null) {
            throw new NullPointerException("No MediaStreamTrack specified for addTransceiver.");
        }
        if (init == null) {
            init = new RtpTransceiver.RtpTransceiverInit();
        }
        if ((newTransceiver = this.nativeAddTransceiverWithTrack(RTCUtils.getNativeMediaStreamTrack(track), init)) == null) {
            throw new IllegalStateException("C++ addTransceiver failed.");
        }
        this.mTransceivers.add(newTransceiver);
        return newTransceiver;
    }

    public void close() {
        this.nativeClose();
    }

    public List<RtpSender> getSenders() {
        for (RtpSender sender : this.mSenders) {
            sender.dispose();
        }
        this.mSenders = this.nativeGetSenders();
        return Collections.unmodifiableList(this.mSenders);
    }

    public boolean removeTrack(RtpSender sender) {
        if (sender == null) {
            throw new NullPointerException("No RtpSender specified for removeTrack.");
        }
        return this.nativeRemoveTrack(RTCUtils.getNativeRtpSender(sender));
    }

    public String getStats() {
        return this.nativeGetStats();
    }

    public String getStats(RtpSender selector) {
        return this.nativeGetStatsForRtpSender(RTCUtils.getNativeRtpSender(selector));
    }

    public String getStats(RtpReceiver selector) {
        return this.nativeGetStatsForRtpReceiver(RTCUtils.getNativeRtpReceiver(selector));
    }

    public long getNativePeerConnection() {
        return this.nativeGetNativePeerConnection();
    }

    @CalledByNative
    long getNativeOwnedPeerConnection() {
        return this.mNativePeerConnection;
    }

    private static native long nativeNewPeerConnection(PrivateListener var0, PeerConnection.RTCConfiguration var1, long var2);

    private static native void nativeFreeOwnedPeerConnection(long var0);

    private native long nativeGetNativePeerConnection();

    private native boolean nativeSetConfiguration(PeerConnection.RTCConfiguration var1);

    private native String nativeCreateOffer(MediaConstraints var1);

    private native String nativeCreateAnswer(MediaConstraints var1);

    private native void nativeSetLocalDescription(int var1, String var2);

    private native void nativeSetRemoteDescription(int var1, String var2);

    private native String nativeGetLocalDescription();

    private native String nativeGetRemoteDescription();

    private native List<RtpSender> nativeGetSenders();

    private native List<RtpTransceiver> nativeGetTransceivers();

    private native boolean nativeRemoveTrack(long var1);

    private native RtpTransceiver nativeAddTransceiverWithTrack(long var1, RtpTransceiver.RtpTransceiverInit var3);

    private native RtpTransceiver nativeAddTransceiverOfType(MediaStreamTrack.MediaType var1);

    private native void nativeClose();

    private native String nativeGetStats();

    private native String nativeGetStatsForRtpSender(long var1);

    private native String nativeGetStatsForRtpReceiver(long var1);

    public static class PrivateListener
    implements PeerConnection.Observer {
        public void onSignalingChange(PeerConnection.SignalingState signalingState) {
        }

        public void onIceConnectionChange(PeerConnection.IceConnectionState iceConnectionState) {
        }

        public void onIceConnectionReceivingChange(boolean b) {
        }

        public void onIceGatheringChange(PeerConnection.IceGatheringState iceGatheringState) {
        }

        public void onIceCandidate(IceCandidate iceCandidate) {
        }

        public void onIceCandidatesRemoved(IceCandidate[] iceCandidates) {
        }

        public void onAddStream(MediaStream mediaStream) {
        }

        public void onRemoveStream(MediaStream mediaStream) {
        }

        public void onDataChannel(DataChannel dataChannel) {
        }

        public void onRenegotiationNeeded() {
        }

        public void onAddTrack(RtpReceiver rtpReceiver, MediaStream[] mediaStreams) {
        }

        public void onConnectionChange(PeerConnection.PeerConnectionState newState) {
        }

        public void onTrack(RtpTransceiver transceiver) {
        }
    }

    public static class Options {
        public PeerConnection.RTCConfiguration mRTCConfig;
        public PeerConnectionFactory mFactory;

        public void setRTCConfig(PeerConnection.RTCConfiguration RTCConfig) {
            this.mRTCConfig = RTCConfig;
        }

        public void setFactory(PeerConnectionFactory factory) {
            this.mFactory = factory;
        }
    }
}

