/*
 * Decompiled with CFR 0.152.
 */
package org.mediasoup.droid;

import android.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.webrtc.CalledByNative;

public class Logger {
    private static LogHandlerInterface logHandler;
    private static long nativeHandler;

    public static void setLogLevel(LogLevel level) {
        if (level == null) {
            throw new IllegalArgumentException("Logging level may not be null.");
        }
        Logger.nativeSetLogLevel(level.getValue());
    }

    public static void setDefaultHandler() {
        Logger.setHandler(new DefaultLogHandler());
    }

    public static void setHandler(LogHandlerInterface handler) {
        logHandler = handler;
        nativeHandler = Logger.nativeSetHandler(handler);
    }

    public static void freeHandler() {
        Logger.nativeFreeLogHandler(nativeHandler);
        nativeHandler = 0L;
    }

    public static void d(String tag, String message) {
        Logger.log(LogLevel.LOG_DEBUG, tag, message);
    }

    public static void e(String tag, String message) {
        Logger.log(LogLevel.LOG_ERROR, tag, message);
    }

    public static void w(String tag, String message) {
        Logger.log(LogLevel.LOG_WARN, tag, message);
    }

    public static void e(String tag, String message, Throwable e) {
        Logger.log(LogLevel.LOG_ERROR, tag, message);
        Logger.log(LogLevel.LOG_ERROR, tag, e.toString());
        Logger.log(LogLevel.LOG_ERROR, tag, Logger.getStackTraceString(e));
    }

    public static void w(String tag, String message, Throwable e) {
        Logger.log(LogLevel.LOG_WARN, tag, message);
        Logger.log(LogLevel.LOG_WARN, tag, e.toString());
        Logger.log(LogLevel.LOG_WARN, tag, Logger.getStackTraceString(e));
    }

    public static void v(String tag, String message) {
        Logger.log(LogLevel.LOG_TRACE, tag, message);
    }

    private static String getStackTraceString(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public static void log(LogLevel level, String tag, String message) {
        if (tag == null || message == null) {
            throw new IllegalArgumentException("Log tag or message may not be null.");
        }
        if (logHandler != null) {
            logHandler.OnLog(level, tag, message);
        }
    }

    private static native void nativeSetLogLevel(int var0);

    private static native long nativeSetHandler(LogHandlerInterface var0);

    private static native void nativeFreeLogHandler(long var0);

    static {
        System.loadLibrary("mediasoupclient_so");
    }

    private static class DefaultLogHandler
    implements LogHandlerInterface {
        private DefaultLogHandler() {
        }

        @Override
        public void OnLog(LogLevel level, String tag, String message) {
            int chunkSize = 2048;
            switch (level) {
                case LOG_ERROR: {
                    for (int i = 0; i < message.length(); i += 2048) {
                        Log.e((String)tag, (String)message.substring(i, Math.min(message.length(), i + 2048)));
                    }
                    break;
                }
                case LOG_WARN: {
                    for (int i = 0; i < message.length(); i += 2048) {
                        Log.w((String)tag, (String)message.substring(i, Math.min(message.length(), i + 2048)));
                    }
                    break;
                }
                case LOG_DEBUG: {
                    for (int i = 0; i < message.length(); i += 2048) {
                        Log.d((String)tag, (String)message.substring(i, Math.min(message.length(), i + 2048)));
                    }
                    break;
                }
                case LOG_TRACE: {
                    for (int i = 0; i < message.length(); i += 2048) {
                        Log.i((String)tag, (String)message.substring(i, Math.min(message.length(), i + 2048)));
                    }
                    break;
                }
            }
        }
    }

    public static interface LogHandlerInterface {
        @CalledByNative(value="LogHandlerInterface")
        public void OnLog(LogLevel var1, String var2, String var3);
    }

    public static enum LogLevel {
        LOG_NONE(0),
        LOG_ERROR(1),
        LOG_WARN(2),
        LOG_DEBUG(3),
        LOG_TRACE(4);

        private final int value;

        private LogLevel(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }

        @CalledByNative(value="LogLevel")
        public static LogLevel getLogLevel(int level) {
            LogLevel[] levels = LogLevel.values();
            for (int i = 0; i < levels.length; ++i) {
                if (levels[i].getValue() != level) continue;
                return levels[i];
            }
            throw new IllegalArgumentException("wrong log level");
        }
    }
}

