/*
 * Decompiled with CFR 0.152.
 */
package org.mediasoup.droid;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import org.mediasoup.droid.MediasoupException;
import org.mediasoup.droid.PeerConnection;
import org.mediasoup.droid.RecvTransport;
import org.mediasoup.droid.SendTransport;
import org.webrtc.PeerConnection;

public class Device {
    private long mNativeDevice = Device.nativeNewDevice();

    public void dispose() {
        this.checkDeviceExists();
        Device.nativeFreeDevice(this.mNativeDevice);
        this.mNativeDevice = 0L;
    }

    public void load(@NonNull String routerRtpCapabilities, PeerConnection.Options peerConnectionOptions) throws MediasoupException {
        this.checkDeviceExists();
        Device.nativeLoad(this.mNativeDevice, routerRtpCapabilities, peerConnectionOptions != null ? peerConnectionOptions.mRTCConfig : null, peerConnectionOptions != null && peerConnectionOptions.mFactory != null ? peerConnectionOptions.mFactory.getNativePeerConnectionFactory() : 0L);
    }

    public boolean isLoaded() {
        this.checkDeviceExists();
        return Device.nativeIsLoaded(this.mNativeDevice);
    }

    public String getRtpCapabilities() throws MediasoupException {
        this.checkDeviceExists();
        return Device.nativeGetRtpCapabilities(this.mNativeDevice);
    }

    public String getSctpCapabilities() throws MediasoupException {
        this.checkDeviceExists();
        return Device.nativeGetSctpCapabilities(this.mNativeDevice);
    }

    public boolean canProduce(@NonNull String kind) throws MediasoupException {
        this.checkDeviceExists();
        return Device.nativeCanProduce(this.mNativeDevice, kind);
    }

    public SendTransport createSendTransport(@NonNull SendTransport.Listener listener, @NonNull String id, @NonNull String iceParameters, @NonNull String iceCandidates, @NonNull String dtlsParameters) throws MediasoupException {
        return this.createSendTransport(listener, id, iceParameters, iceCandidates, dtlsParameters, null, null, null);
    }

    public SendTransport createSendTransport(@NonNull SendTransport.Listener listener, @NonNull String id, @NonNull String iceParameters, @NonNull String iceCandidates, @NonNull String dtlsParameters, @Nullable String sctpParameters) throws MediasoupException {
        return this.createSendTransport(listener, id, iceParameters, iceCandidates, dtlsParameters, sctpParameters, null, null);
    }

    public SendTransport createSendTransport(@NonNull SendTransport.Listener listener, @NonNull String id, @NonNull String iceParameters, @NonNull String iceCandidates, @NonNull String dtlsParameters, @Nullable String sctpParameters, @Nullable PeerConnection.Options options, @Nullable String appData) throws MediasoupException {
        this.checkDeviceExists();
        return Device.nativeCreateSendTransport(this.mNativeDevice, listener, id, iceParameters, iceCandidates, dtlsParameters, sctpParameters, options != null ? options.mRTCConfig : null, options != null && options.mFactory != null ? options.mFactory.getNativePeerConnectionFactory() : 0L, appData);
    }

    public RecvTransport createRecvTransport(@NonNull RecvTransport.Listener listener, @NonNull String id, @NonNull String iceParameters, @NonNull String iceCandidates, @NonNull String dtlsParameters) throws MediasoupException {
        return this.createRecvTransport(listener, id, iceParameters, iceCandidates, dtlsParameters, null, null, null);
    }

    public RecvTransport createRecvTransport(@NonNull RecvTransport.Listener listener, @NonNull String id, @NonNull String iceParameters, @NonNull String iceCandidates, @NonNull String dtlsParameters, @Nullable String sctpParameters) throws MediasoupException {
        return this.createRecvTransport(listener, id, iceParameters, iceCandidates, dtlsParameters, sctpParameters, null, null);
    }

    public RecvTransport createRecvTransport(@NonNull RecvTransport.Listener listener, @NonNull String id, @NonNull String iceParameters, @NonNull String iceCandidates, @NonNull String dtlsParameters, @Nullable String sctpParameters, @Nullable PeerConnection.Options options, @Nullable String appData) throws MediasoupException {
        this.checkDeviceExists();
        return Device.nativeCreateRecvTransport(this.mNativeDevice, listener, id, iceParameters, iceCandidates, dtlsParameters, sctpParameters, options != null ? options.mRTCConfig : null, options != null && options.mFactory != null ? options.mFactory.getNativePeerConnectionFactory() : 0L, appData);
    }

    private void checkDeviceExists() {
        if (this.mNativeDevice == 0L) {
            throw new IllegalStateException("Device has been disposed.");
        }
    }

    private static native long nativeNewDevice();

    private static native void nativeFreeDevice(long var0);

    private static native void nativeLoad(long var0, String var2, PeerConnection.RTCConfiguration var3, long var4);

    private static native boolean nativeIsLoaded(long var0);

    private static native String nativeGetRtpCapabilities(long var0);

    private static native String nativeGetSctpCapabilities(long var0);

    private static native boolean nativeCanProduce(long var0, String var2);

    private static native SendTransport nativeCreateSendTransport(long var0, SendTransport.Listener var2, String var3, String var4, String var5, String var6, String var7, PeerConnection.RTCConfiguration var8, long var9, String var11);

    private static native RecvTransport nativeCreateRecvTransport(long var0, RecvTransport.Listener var2, String var3, String var4, String var5, String var6, String var7, PeerConnection.RTCConfiguration var8, long var9, String var11);
}

