/*
 * Decompiled with CFR 0.152.
 */
package org.mediasoup.droid;

import org.webrtc.CalledByNative;
import org.webrtc.DataChannel;

public class DataProducer {
    private final long mNativeProducer;

    @CalledByNative
    public DataProducer(long nativeProducer) {
        this.mNativeProducer = nativeProducer;
    }

    public String getId() {
        return DataProducer.nativeGetId(this.mNativeProducer);
    }

    public String getLocalId() {
        return DataProducer.nativeGetLocalId(this.mNativeProducer);
    }

    public String getSctpStreamParameters() {
        return DataProducer.nativeGetSctpStreamParameters(this.mNativeProducer);
    }

    public DataChannel.State getReadyState() {
        return DataChannel.State.values()[DataProducer.nativeGetReadyState(this.mNativeProducer)];
    }

    public String getLabel() {
        return DataProducer.nativeGetLabel(this.mNativeProducer);
    }

    public String getProtocol() {
        return DataProducer.nativeGetProtocol(this.mNativeProducer);
    }

    public long getBufferedAmount() {
        return DataProducer.nativeGetBufferedAmount(this.mNativeProducer);
    }

    public String getAppData() {
        return DataProducer.nativeGetAppData(this.mNativeProducer);
    }

    public boolean isClosed() {
        return DataProducer.nativeIsClosed(this.mNativeProducer);
    }

    public void close() {
        DataProducer.nativeClose(this.mNativeProducer);
    }

    public void send(DataChannel.Buffer buffer) {
        byte[] data = new byte[buffer.data.remaining()];
        buffer.data.get(data);
        DataProducer.nativeSend(this.mNativeProducer, data, buffer.binary);
    }

    private static native String nativeGetId(long var0);

    private static native String nativeGetLocalId(long var0);

    private static native String nativeGetSctpStreamParameters(long var0);

    private static native int nativeGetReadyState(long var0);

    private static native String nativeGetLabel(long var0);

    private static native String nativeGetProtocol(long var0);

    private static native long nativeGetBufferedAmount(long var0);

    private static native String nativeGetAppData(long var0);

    private static native boolean nativeIsClosed(long var0);

    private static native void nativeClose(long var0);

    private static native void nativeSend(long var0, byte[] var2, boolean var3);

    public static interface Listener {
        @CalledByNative(value="DataProducerListener")
        public void onOpen(DataProducer var1);

        @CalledByNative(value="DataProducerListener")
        public void onClose(DataProducer var1);

        @CalledByNative(value="DataProducerListener")
        public void onBufferedAmountChange(DataProducer var1, long var2);

        @CalledByNative(value="DataProducerListener")
        public void onTransportClose(DataProducer var1);
    }
}

