/*
 * Decompiled with CFR 0.152.
 */
package org.mediasoup.droid;

import java.nio.ByteBuffer;
import org.webrtc.CalledByNative;
import org.webrtc.DataChannel;

public class DataConsumer {
    private final long mNativeConsumer;

    @CalledByNative
    public static DataChannel.Buffer generateBuffer(ByteBuffer data, boolean binary) {
        return new DataChannel.Buffer(data, binary);
    }

    @CalledByNative
    public DataConsumer(long nativeConsumer) {
        this.mNativeConsumer = nativeConsumer;
    }

    public String getId() {
        return DataConsumer.nativeGetId(this.mNativeConsumer);
    }

    public String getLocalId() {
        return DataConsumer.nativeGetLocalId(this.mNativeConsumer);
    }

    public String getDataProducerId() {
        return DataConsumer.nativeGetDataProducerId(this.mNativeConsumer);
    }

    public String getSctpStreamParameters() {
        return DataConsumer.nativeGetSctpStreamParameters(this.mNativeConsumer);
    }

    public DataChannel.State getReadyState() {
        return DataChannel.State.values()[DataConsumer.nativeGetReadyState(this.mNativeConsumer)];
    }

    public String getLabel() {
        return DataConsumer.nativeGetLabel(this.mNativeConsumer);
    }

    public String getProtocol() {
        return DataConsumer.nativeGetProtocol(this.mNativeConsumer);
    }

    public String getAppData() {
        return DataConsumer.nativeGetAppData(this.mNativeConsumer);
    }

    public boolean isClosed() {
        return DataConsumer.nativeIsClosed(this.mNativeConsumer);
    }

    public void close() {
        DataConsumer.nativeClose(this.mNativeConsumer);
    }

    private static native String nativeGetId(long var0);

    private static native String nativeGetDataProducerId(long var0);

    private static native String nativeGetLocalId(long var0);

    private static native String nativeGetSctpStreamParameters(long var0);

    private static native int nativeGetReadyState(long var0);

    private static native String nativeGetLabel(long var0);

    private static native String nativeGetProtocol(long var0);

    private static native String nativeGetAppData(long var0);

    private static native boolean nativeIsClosed(long var0);

    private static native void nativeClose(long var0);

    public static interface Listener {
        @CalledByNative(value="DataConsumerListener")
        public void OnConnecting(DataConsumer var1);

        @CalledByNative(value="DataConsumerListener")
        public void OnOpen(DataConsumer var1);

        @CalledByNative(value="DataConsumerListener")
        public void OnClosing(DataConsumer var1);

        @CalledByNative(value="DataConsumerListener")
        public void OnClose(DataConsumer var1);

        @CalledByNative(value="DataConsumerListener")
        public void OnMessage(DataConsumer var1, DataChannel.Buffer var2);

        @CalledByNative(value="DataConsumerListener")
        public void OnTransportClose(DataConsumer var1);
    }
}

