/*
 * Decompiled with CFR 0.152.
 */
package org.mediasoup.droid;

import androidx.annotation.Nullable;
import org.mediasoup.droid.MediasoupException;
import org.webrtc.CalledByNative;
import org.webrtc.MediaStreamTrack;
import org.webrtc.RTCUtils;

public class Consumer {
    private final long mNativeConsumer;
    @Nullable
    private final MediaStreamTrack mCachedTrack;

    @CalledByNative
    public Consumer(long nativeConsumer) {
        this.mNativeConsumer = nativeConsumer;
        long nativeTrack = Consumer.nativeGetTrack(this.mNativeConsumer);
        this.mCachedTrack = RTCUtils.createMediaStreamTrack(nativeTrack);
    }

    public String getId() {
        return Consumer.nativeGetNativeId(this.mNativeConsumer);
    }

    public String getLocalId() {
        return Consumer.nativeGetLocalId(this.mNativeConsumer);
    }

    public String getProducerId() {
        return Consumer.nativeGetProducerId(this.mNativeConsumer);
    }

    public boolean isClosed() {
        return Consumer.nativeIsClosed(this.mNativeConsumer);
    }

    public boolean isPaused() {
        return Consumer.nativeIsPaused(this.mNativeConsumer);
    }

    public String getKind() {
        return Consumer.nativeGetKind(this.mNativeConsumer);
    }

    public MediaStreamTrack getTrack() {
        return this.mCachedTrack;
    }

    public String getRtpParameters() {
        return Consumer.nativeGetRtpParameters(this.mNativeConsumer);
    }

    public String getAppData() {
        return Consumer.nativeGetAppData(this.mNativeConsumer);
    }

    public void resume() {
        Consumer.nativeResume(this.mNativeConsumer);
    }

    public void pause() {
        Consumer.nativePause(this.mNativeConsumer);
    }

    public String getStats() throws MediasoupException {
        return Consumer.nativeGetStats(this.mNativeConsumer);
    }

    public void close() {
        Consumer.nativeClose(this.mNativeConsumer);
    }

    private static native String nativeGetNativeId(long var0);

    private static native String nativeGetLocalId(long var0);

    private static native String nativeGetProducerId(long var0);

    private static native boolean nativeIsClosed(long var0);

    private static native boolean nativeIsPaused(long var0);

    private static native String nativeGetKind(long var0);

    private static native long nativeGetTrack(long var0);

    private static native String nativeGetRtpParameters(long var0);

    private static native String nativeGetAppData(long var0);

    private static native void nativeResume(long var0);

    private static native void nativePause(long var0);

    private static native String nativeGetStats(long var0);

    private static native void nativeClose(long var0);

    public static interface Listener {
        @CalledByNative(value="Listener")
        public void onTransportClose(Consumer var1);
    }
}

