/*
 * Decompiled with CFR 0.152.
 */
package io.github.habeebcycle.querybuilder;

import io.github.habeebcycle.querybuilder.FilterBuilder;
import io.github.habeebcycle.querybuilder.fragment.QueryFragment;
import io.github.habeebcycle.querybuilder.keyword.QueryKeyword;
import io.github.habeebcycle.querybuilder.utils.Constant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class QueryBuilder {
    private final List<QueryFragment> queryFragment = new ArrayList<QueryFragment>();

    public QueryBuilder orderBy(String fields) {
        this.clear(QueryKeyword.ORDER_BY);
        this.queryFragment.add(new QueryFragment(QueryKeyword.ORDER_BY, String.format("%s%s", QueryKeyword.ORDER_BY.getKeyword(), fields)));
        return this;
    }

    public QueryBuilder top(int top) {
        this.clear(QueryKeyword.TOP);
        this.queryFragment.add(new QueryFragment(QueryKeyword.TOP, String.format("%s%s", QueryKeyword.TOP.getKeyword(), top)));
        return this;
    }

    public QueryBuilder skip(int skip) {
        this.clear(QueryKeyword.SKIP);
        this.queryFragment.add(new QueryFragment(QueryKeyword.SKIP, String.format("%s%s", QueryKeyword.SKIP.getKeyword(), skip)));
        return this;
    }

    public QueryBuilder count() {
        this.clear(QueryKeyword.COUNT);
        this.queryFragment.add(new QueryFragment(QueryKeyword.COUNT, String.format("%s%s", QueryKeyword.COUNT.getKeyword(), true)));
        return this;
    }

    public QueryBuilder expand(String fields) {
        this.clear(QueryKeyword.EXPAND);
        this.queryFragment.add(new QueryFragment(QueryKeyword.EXPAND, String.format("%s%s", QueryKeyword.EXPAND.getKeyword(), fields)));
        return this;
    }

    public QueryBuilder select(String fields) {
        return this.select(fields.split(Constant.COM));
    }

    public QueryBuilder select(String ... fields) {
        return this.select(Arrays.asList(fields));
    }

    public QueryBuilder select(List<String> fields) {
        this.clear(QueryKeyword.SELECT);
        this.queryFragment.add(new QueryFragment(QueryKeyword.SELECT, String.format("%s%s", QueryKeyword.SELECT.getKeyword(), this.trimJoin(fields))));
        return this;
    }

    public QueryBuilder filter(Function<FilterBuilder, FilterBuilder> filter) {
        return this.filter(filter, Constant.AND);
    }

    public QueryBuilder filter(Function<FilterBuilder, FilterBuilder> filter, String operator) {
        this.clear(QueryKeyword.FILTER);
        this.queryFragment.add(new QueryFragment(QueryKeyword.FILTER, filter.apply(new FilterBuilder()).toQuery(operator)));
        return this;
    }

    public String toQuery() {
        if (this.queryFragment.isEmpty()) {
            return "";
        }
        List sortedFragments = this.queryFragment.stream().sorted(Comparator.comparing(QueryFragment::getKeywordOrder)).collect(Collectors.toList());
        List unSortedFragment = sortedFragments.stream().filter((? super T f) -> !f.getQueryKeyword().equals((Object)QueryKeyword.FILTER)).collect(Collectors.toList());
        List<QueryFragment> filterFragment = sortedFragments.stream().filter((? super T f) -> f.getQueryKeyword().equals((Object)QueryKeyword.FILTER)).collect(Collectors.toList());
        String query = String.format("?%s", sortedFragments.stream().filter((? super T f) -> !f.getQueryKeyword().equals((Object)QueryKeyword.FILTER)).map(QueryFragment::getValue).collect(Collectors.joining(Constant.AMP)));
        if (filterFragment.isEmpty()) {
            return query;
        }
        if (!unSortedFragment.isEmpty()) {
            query = query.concat(Constant.AMP);
        }
        return query.concat(this.parseFilters(filterFragment, Constant.AND).trim());
    }

    private String parseFilters(List<QueryFragment> fragments, String operator) {
        if (fragments == null || fragments.isEmpty()) {
            return "";
        }
        return QueryKeyword.FILTER.getKeyword().concat(fragments.stream().map(QueryFragment::getValue).collect(Collectors.joining(String.format(" %s ", operator))));
    }

    private void clear(QueryKeyword queryKeyword) {
        this.queryFragment.removeIf(f -> f.getQueryKeyword().equals((Object)queryKeyword));
    }

    private String trimJoin(List<String> arr) {
        return arr.stream().map(String::trim).collect(Collectors.joining(Constant.COM));
    }
}

