/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.directives;

import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.directives.CommonPropertiesCreator;
import graphql.annotations.processor.typeFunctions.TypeFunction;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLInputType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

public class DirectiveArgumentCreator {
    private CommonPropertiesCreator commonPropertiesCreator;
    private TypeFunction typeFunction;
    private ProcessingElementsContainer container;

    public DirectiveArgumentCreator(CommonPropertiesCreator commonPropertiesCreator, TypeFunction typeFunction, ProcessingElementsContainer container) {
        this.commonPropertiesCreator = commonPropertiesCreator;
        this.typeFunction = typeFunction;
        this.container = container;
    }

    public GraphQLArgument getArgument(Field field, Class<?> containingClass) {
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument().name(this.commonPropertiesCreator.getName(field)).description(this.commonPropertiesCreator.getDescription(field)).type(this.getType(field));
        try {
            builder.defaultValue(this.getDefaultValue(field, containingClass));
        }
        catch (IllegalAccessException | InstantiationException e) {
            builder.defaultValue(null);
        }
        return builder.build();
    }

    public GraphQLArgument getArgument(Method method) {
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument().name(this.commonPropertiesCreator.getName(method)).description(this.commonPropertiesCreator.getDescription(method)).type(this.getType(method));
        builder.defaultValue(method.getDefaultValue());
        return builder.build();
    }

    private Object getDefaultValue(Field field, Class<?> containingClass) throws IllegalAccessException, InstantiationException {
        field.setAccessible(true);
        Object object = containingClass.newInstance();
        return field.get(object);
    }

    private GraphQLInputType getType(Field field) {
        return (GraphQLInputType)this.typeFunction.buildType(true, field.getType(), field.getAnnotatedType(), this.container);
    }

    private GraphQLInputType getType(Method method) {
        return (GraphQLInputType)this.typeFunction.buildType(true, method.getReturnType(), method.getAnnotatedReturnType(), this.container);
    }

    private GraphQLInputType getType(Parameter parameter) {
        return (GraphQLInputType)this.typeFunction.buildType(true, parameter.getType(), parameter.getAnnotatedType(), this.container);
    }

    public GraphQLArgument getArgument(Parameter parameter) {
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument().name(this.commonPropertiesCreator.getName(parameter)).description(this.commonPropertiesCreator.getDescription(parameter)).type(this.getType(parameter));
        return builder.build();
    }
}

