/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.dataFetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLOutputType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RelayMutationMethodDataFetcher
implements DataFetcher {
    private final Method method;
    private final List<GraphQLArgument> args;
    private final GraphQLInputType input;
    private final GraphQLOutputType type;
    private final int envIndex;

    public RelayMutationMethodDataFetcher(Method method, List<GraphQLArgument> args, GraphQLInputType input, GraphQLOutputType type) {
        this.method = method;
        this.args = args;
        this.input = input;
        this.type = type;
        List parameterTypes = Arrays.asList(method.getParameters()).stream().map(Parameter::getType).collect(Collectors.toList());
        this.envIndex = parameterTypes.indexOf(DataFetchingEnvironment.class);
    }

    public Object get(DataFetchingEnvironment environment) {
        if (environment.getSource() == null) {
            return null;
        }
        try {
            Map input = (Map)environment.getArgument("input");
            List args = this.args.stream().map(arg -> input.get(arg.getName())).collect(Collectors.toList());
            if (this.envIndex >= 0) {
                args.add(this.envIndex, environment);
            }
            return this.method.invoke(environment.getSource(), args.toArray());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

