/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.typeFunctions;

import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.typeFunctions.DefaultTypeFunction;
import graphql.annotations.processor.typeFunctions.TypeFunction;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLType;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.ParameterizedType;

public class ArrayFunction
implements TypeFunction {
    private DefaultTypeFunction defaultTypeFunction;

    public ArrayFunction(DefaultTypeFunction defaultTypeFunction) {
        this.defaultTypeFunction = defaultTypeFunction;
    }

    @Override
    public boolean canBuildType(Class<?> aClass, AnnotatedType annotatedType) {
        return aClass.isArray();
    }

    @Override
    public GraphQLType buildType(boolean input, Class<?> aClass, AnnotatedType annotatedType, ProcessingElementsContainer container) {
        if (!(annotatedType instanceof AnnotatedArrayType)) {
            throw new IllegalArgumentException("Array type parameter should be specified");
        }
        AnnotatedArrayType parameterizedType = (AnnotatedArrayType)annotatedType;
        AnnotatedType arg = parameterizedType.getAnnotatedGenericComponentType();
        Class klass = arg.getType() instanceof ParameterizedType ? (Class)((ParameterizedType)arg.getType()).getRawType() : (Class)arg.getType();
        return new GraphQLList(this.defaultTypeFunction.buildType(input, klass, arg, container));
    }
}

