/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations;

import graphql.annotations.processor.GraphQLAnnotations;
import graphql.annotations.processor.typeFunctions.TypeFunction;
import graphql.relay.Relay;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class AnnotationsSchemaCreator {
    public static Builder newAnnotationsSchema() {
        return new Builder();
    }

    public static class Builder {
        private Class<?> queryObject;
        private Class<?> mutationObject;
        private Class<?> subscriptionObject;
        private Set<Class<?>> directivesObjectList = new HashSet();
        private Set<Class<?>> directiveContainerClasses = new HashSet();
        private Set<Class<?>> additionalTypesList = new HashSet();
        private Set<Class<?>> typeExtensions = new HashSet();
        private Set<TypeFunction> typeFunctions = new HashSet<TypeFunction>();
        private Boolean shouldAlwaysPrettify = null;
        private GraphQLAnnotations graphQLAnnotations;
        private GraphQLSchema.Builder graphqlSchemaBuilder;

        public Builder setGraphQLSchemaBuilder(GraphQLSchema.Builder schemaBuilder) {
            this.graphqlSchemaBuilder = schemaBuilder;
            return this;
        }

        public Builder setAnnotationsProcessor(GraphQLAnnotations annotationsProcessor) {
            this.graphQLAnnotations = annotationsProcessor;
            return this;
        }

        public Builder query(Class<?> queryClass) {
            this.queryObject = queryClass;
            return this;
        }

        public Builder mutation(Class<?> mutationClass) {
            this.mutationObject = mutationClass;
            return this;
        }

        public Builder subscription(Class<?> subscriptionClass) {
            this.subscriptionObject = subscriptionClass;
            return this;
        }

        public Builder directives(Set<Class<?>> directiveClasses) {
            this.directivesObjectList.addAll(directiveClasses);
            return this;
        }

        public Builder directives(Class<?> directiveContainerClass) {
            this.directiveContainerClasses.add(directiveContainerClass);
            return this;
        }

        public Builder directive(Class<?> directiveClass) {
            this.directivesObjectList.add(directiveClass);
            return this;
        }

        public Builder additionalType(Class<?> additionalTypeClass) {
            this.additionalTypesList.add(additionalTypeClass);
            return this;
        }

        public Builder additionalTypes(Set<Class<?>> additionalTypes) {
            this.additionalTypesList.addAll(additionalTypes);
            return this;
        }

        public Builder typeExtension(Class<?> typeExtension) {
            this.typeExtensions.add(typeExtension);
            return this;
        }

        public Builder typeFunction(TypeFunction typeFunction) {
            this.typeFunctions.add(typeFunction);
            return this;
        }

        public Builder setAlwaysPrettify(Boolean shouldAlwaysPrettify) {
            this.shouldAlwaysPrettify = shouldAlwaysPrettify;
            return this;
        }

        public Builder setRelay(Relay relay) {
            this.graphQLAnnotations.setRelay(relay);
            return this;
        }

        public GraphQLAnnotations getGraphQLAnnotations() {
            return this.graphQLAnnotations;
        }

        public GraphQLSchema build() {
            assert (this.queryObject != null);
            if (this.graphQLAnnotations == null) {
                this.graphQLAnnotations = new GraphQLAnnotations();
            }
            if (this.graphqlSchemaBuilder == null) {
                this.graphqlSchemaBuilder = new GraphQLSchema.Builder();
            }
            this.typeExtensions.forEach(typeExtension -> this.graphQLAnnotations.registerTypeExtension((Class<?>)typeExtension));
            this.typeFunctions.forEach(typeFunction -> this.graphQLAnnotations.registerTypeFunction((TypeFunction)typeFunction));
            if (this.shouldAlwaysPrettify != null) {
                this.graphQLAnnotations.getObjectHandler().getTypeRetriever().getGraphQLFieldRetriever().setAlwaysPrettify(this.shouldAlwaysPrettify);
            }
            Set directives = this.directivesObjectList.stream().map(dir -> this.graphQLAnnotations.directive((Class<?>)dir)).collect(Collectors.toSet());
            this.directiveContainerClasses.forEach(dir -> directives.addAll(this.graphQLAnnotations.directives((Class<?>)dir)));
            Set additionalTypes = this.additionalTypesList.stream().map(additionalType -> additionalType.isInterface() ? this.graphQLAnnotations.generateInterface((Class<?>)additionalType) : this.graphQLAnnotations.object((Class<?>)additionalType)).collect(Collectors.toSet());
            this.graphqlSchemaBuilder.query(this.graphQLAnnotations.object(this.queryObject));
            if (this.mutationObject != null) {
                this.graphqlSchemaBuilder.mutation(this.graphQLAnnotations.object(this.mutationObject));
            }
            if (this.subscriptionObject != null) {
                this.graphqlSchemaBuilder.subscription(this.graphQLAnnotations.object(this.subscriptionObject));
            }
            if (!directives.isEmpty()) {
                this.graphqlSchemaBuilder.additionalDirectives(directives);
            }
            this.graphqlSchemaBuilder.additionalTypes(additionalTypes).additionalType((GraphQLType)Relay.pageInfoType).codeRegistry(this.graphQLAnnotations.getContainer().getCodeRegistryBuilder().build());
            return this.graphqlSchemaBuilder.build();
        }
    }
}

