/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.util;

import graphql.annotations.processor.exceptions.GraphQLAnnotationsException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ReflectionKit {
    public static <T> T newInstance(Class<T> clazz) throws GraphQLAnnotationsException {
        try {
            try {
                Method getInstance = clazz.getMethod("getInstance", new Class[0]);
                if (Modifier.isStatic(getInstance.getModifiers()) && clazz.isAssignableFrom(getInstance.getReturnType())) {
                    return (T)getInstance.invoke(null, new Object[0]);
                }
            }
            catch (NoSuchMethodException getInstance) {
                // empty catch block
            }
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new GraphQLAnnotationsException("Unable to instantiate class : " + clazz, e);
        }
    }

    public static <T> T constructNewInstance(Constructor<T> constructor, Object ... args) throws GraphQLAnnotationsException {
        try {
            return constructor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new GraphQLAnnotationsException("Unable to instantiate via constructor : " + constructor, e);
        }
    }

    public static <T> Constructor<T> constructor(Class<T> type, Class<?> ... parameterTypes) {
        try {
            return type.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new GraphQLAnnotationsException("Unable to find constructor", e);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object parameter) {
        if (parameter != null) {
            for (Constructor<?> constructor : clazz.getConstructors()) {
                if (constructor.getParameterCount() != 1 || !constructor.getParameters()[0].getType().isAssignableFrom(parameter.getClass())) continue;
                return (T)ReflectionKit.constructNewInstance(constructor, parameter);
            }
        }
        return null;
    }
}

