/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.typeBuilders;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLTypeResolver;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.exceptions.GraphQLAnnotationsException;
import graphql.annotations.processor.retrievers.GraphQLExtensionsHandler;
import graphql.annotations.processor.retrievers.GraphQLFieldRetriever;
import graphql.annotations.processor.retrievers.GraphQLInterfaceRetriever;
import graphql.annotations.processor.retrievers.GraphQLObjectInfoRetriever;
import graphql.annotations.processor.searchAlgorithms.SearchAlgorithm;
import graphql.annotations.processor.util.ObjectUtil;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLTypeReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OutputObjectBuilder {
    private GraphQLObjectInfoRetriever graphQLObjectInfoRetriever;
    private SearchAlgorithm methodSearchAlgorithm;
    private SearchAlgorithm fieldSearchAlgorithm;
    private GraphQLFieldRetriever graphQLFieldRetriever;
    private GraphQLInterfaceRetriever graphQLInterfaceRetriever;
    private GraphQLExtensionsHandler extensionsHandler;

    public OutputObjectBuilder(GraphQLObjectInfoRetriever graphQLObjectInfoRetriever, SearchAlgorithm fieldSearchAlgorithm, SearchAlgorithm methodSearchAlgorithm, GraphQLFieldRetriever graphQLFieldRetriever, GraphQLInterfaceRetriever graphQLInterfaceRetriever, GraphQLExtensionsHandler extensionsHandler) {
        this.graphQLObjectInfoRetriever = graphQLObjectInfoRetriever;
        this.methodSearchAlgorithm = methodSearchAlgorithm;
        this.fieldSearchAlgorithm = fieldSearchAlgorithm;
        this.graphQLFieldRetriever = graphQLFieldRetriever;
        this.graphQLInterfaceRetriever = graphQLInterfaceRetriever;
        this.extensionsHandler = extensionsHandler;
    }

    public GraphQLObjectType.Builder getOutputObjectBuilder(Class<?> object, ProcessingElementsContainer container) throws GraphQLAnnotationsException {
        GraphQLFieldDefinition gqlField;
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject();
        builder.name(this.graphQLObjectInfoRetriever.getTypeName(object));
        GraphQLDescription description = object.getAnnotation(GraphQLDescription.class);
        if (description != null) {
            builder.description(description.value());
        }
        ArrayList<String> definedFields = new ArrayList<String>();
        for (Method method : this.graphQLObjectInfoRetriever.getOrderedMethods(object)) {
            if (method.isBridge() || method.isSynthetic() || !this.methodSearchAlgorithm.isFound(method)) continue;
            gqlField = this.graphQLFieldRetriever.getField(method, container);
            definedFields.add(gqlField.getName());
            builder.field(gqlField);
        }
        for (Field field : ObjectUtil.getAllFields(object).values()) {
            if (Modifier.isStatic(field.getModifiers()) || !this.fieldSearchAlgorithm.isFound(field)) continue;
            gqlField = this.graphQLFieldRetriever.getField(field, container);
            definedFields.add(gqlField.getName());
            builder.field(gqlField);
        }
        for (Iterator<AccessibleObject> iterator : object.getInterfaces()) {
            if (((Class)((Object)iterator)).getAnnotation(GraphQLTypeResolver.class) == null) continue;
            String ifaceName = this.graphQLObjectInfoRetriever.getTypeName((Class<?>)((Object)iterator));
            if (container.getProcessing().contains(ifaceName)) {
                builder.withInterface(new GraphQLTypeReference(ifaceName));
            } else {
                builder.withInterface((GraphQLInterfaceType)this.graphQLInterfaceRetriever.getInterface((Class<?>)((Object)iterator), container));
            }
            builder.fields(this.extensionsHandler.getExtensionFields((Class<?>)((Object)iterator), (List<String>)definedFields, container));
        }
        builder.fields(this.extensionsHandler.getExtensionFields(object, definedFields, container));
        return builder;
    }
}

