/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.typeFunctions;

import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.graphQLProcessors.GraphQLAnnotationsProcessor;
import graphql.annotations.processor.graphQLProcessors.GraphQLInputProcessor;
import graphql.annotations.processor.graphQLProcessors.GraphQLOutputProcessor;
import graphql.annotations.processor.typeFunctions.BooleanFunction;
import graphql.annotations.processor.typeFunctions.FloatFunction;
import graphql.annotations.processor.typeFunctions.IDFunction;
import graphql.annotations.processor.typeFunctions.IntegerFunction;
import graphql.annotations.processor.typeFunctions.IterableFunction;
import graphql.annotations.processor.typeFunctions.LongFunction;
import graphql.annotations.processor.typeFunctions.ObjectFunction;
import graphql.annotations.processor.typeFunctions.OptionalFunction;
import graphql.annotations.processor.typeFunctions.StreamFunction;
import graphql.annotations.processor.typeFunctions.StringFunction;
import graphql.annotations.processor.typeFunctions.TypeFunction;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(property={"type=default"})
public class DefaultTypeFunction
implements TypeFunction {
    protected List<TypeFunction> otherFunctions = new ArrayList<TypeFunction>();
    private CopyOnWriteArrayList<TypeFunction> typeFunctions = new CopyOnWriteArrayList();
    GraphQLAnnotationsProcessor annotationsProcessor;

    @Override
    public boolean canBuildType(Class<?> aClass, AnnotatedType annotatedType) {
        return this.getTypeFunction(aClass, annotatedType) != null;
    }

    public void setAnnotationsProcessor(GraphQLAnnotationsProcessor annotationsProcessor) {
        this.annotationsProcessor = annotationsProcessor;
    }

    public DefaultTypeFunction(GraphQLInputProcessor graphQLInputProcessor, GraphQLOutputProcessor graphQLOutputProcessor) {
        this.typeFunctions.add(new IDFunction());
        this.typeFunctions.add(new StringFunction());
        this.typeFunctions.add(new BooleanFunction());
        this.typeFunctions.add(new FloatFunction());
        this.typeFunctions.add(new IntegerFunction());
        this.typeFunctions.add(new LongFunction());
        this.typeFunctions.add(new IterableFunction(this));
        this.typeFunctions.add(new StreamFunction(this));
        this.typeFunctions.add(new OptionalFunction(this));
        this.typeFunctions.add(new ObjectFunction(graphQLInputProcessor, graphQLOutputProcessor));
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, service=TypeFunction.class, target="(!(type=default))")
    void addFunction(TypeFunction function) {
        this.otherFunctions.add(function);
    }

    void removeFunction(TypeFunction function) {
        this.otherFunctions.remove(function);
    }

    @Activate
    protected void activate() {
        for (TypeFunction function : this.otherFunctions) {
            this.register(function);
        }
    }

    public Class<DefaultTypeFunction> register(TypeFunction function) {
        this.typeFunctions.add(0, function);
        return DefaultTypeFunction.class;
    }

    @Override
    public String getTypeName(Class<?> aClass, AnnotatedType annotatedType) {
        TypeFunction typeFunction = this.getTypeFunction(aClass, annotatedType);
        if (typeFunction == null) {
            throw new IllegalArgumentException("unsupported type");
        }
        return typeFunction.getTypeName(aClass, annotatedType);
    }

    @Override
    public GraphQLType buildType(boolean input, Class<?> aClass, AnnotatedType annotatedType, ProcessingElementsContainer container) {
        TypeFunction typeFunction = this.getTypeFunction(aClass, annotatedType);
        if (typeFunction == null) {
            throw new IllegalArgumentException("unsupported type");
        }
        GraphQLType result = typeFunction.buildType(input, aClass, annotatedType, container);
        if (annotatedType != null && annotatedType.isAnnotationPresent(graphql.annotations.annotationTypes.GraphQLNonNull.class)) {
            result = new GraphQLNonNull(result);
        }
        return result;
    }

    private TypeFunction getTypeFunction(Class<?> aClass, AnnotatedType annotatedType) {
        for (TypeFunction typeFunction : this.typeFunctions) {
            if (!typeFunction.canBuildType(aClass, annotatedType)) continue;
            return typeFunction;
        }
        return null;
    }
}

