/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.typeFunctions;

import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.typeFunctions.DefaultTypeFunction;
import graphql.annotations.processor.typeFunctions.TypeFunction;
import graphql.schema.GraphQLType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.ParameterizedType;
import java.util.Optional;

class OptionalFunction
implements TypeFunction {
    private DefaultTypeFunction defaultTypeFunction;

    public OptionalFunction(DefaultTypeFunction defaultTypeFunction) {
        this.defaultTypeFunction = defaultTypeFunction;
    }

    @Override
    public boolean canBuildType(Class<?> aClass, AnnotatedType annotatedType) {
        return aClass == Optional.class;
    }

    @Override
    public String getTypeName(Class<?> aClass, AnnotatedType annotatedType) {
        AnnotatedType arg = this.getAnnotatedType(annotatedType);
        return this.defaultTypeFunction.getTypeName(this.getClass(annotatedType), arg);
    }

    @Override
    public GraphQLType buildType(boolean input, Class<?> aClass, AnnotatedType annotatedType, ProcessingElementsContainer container) {
        AnnotatedType arg = this.getAnnotatedType(annotatedType);
        return this.defaultTypeFunction.buildType(input, this.getClass(annotatedType), arg, container);
    }

    private AnnotatedType getAnnotatedType(AnnotatedType annotatedType) {
        if (!(annotatedType instanceof AnnotatedParameterizedType)) {
            throw new IllegalArgumentException("Optional type parameter should be specified");
        }
        AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)annotatedType;
        return parameterizedType.getAnnotatedActualTypeArguments()[0];
    }

    private Class<?> getClass(AnnotatedType annotatedType) {
        AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)annotatedType;
        AnnotatedType arg = parameterizedType.getAnnotatedActualTypeArguments()[0];
        if (arg.getType() instanceof ParameterizedType) {
            return (Class)((ParameterizedType)arg.getType()).getRawType();
        }
        return (Class)arg.getType();
    }
}

