/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.retrievers.fieldBuilders.field;

import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLPrettify;
import graphql.annotations.processor.retrievers.fieldBuilders.Builder;
import graphql.annotations.processor.util.NamingKit;
import java.lang.reflect.Field;

public class FieldNameBuilder
implements Builder<String> {
    private Field field;

    public FieldNameBuilder(Field field) {
        this.field = field;
    }

    @Override
    public String build() {
        if (this.field.isAnnotationPresent(GraphQLPrettify.class) && !this.field.isAnnotationPresent(GraphQLName.class)) {
            return NamingKit.toGraphqlName(this.prettifyName(this.field.getName()));
        }
        GraphQLName name = this.field.getAnnotation(GraphQLName.class);
        return NamingKit.toGraphqlName(name == null ? this.field.getName() : name.value());
    }

    private String prettifyName(String originalName) {
        String name = originalName.replaceFirst("^(is|get|set)(.+)", "$2");
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }
}

