/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

class MethodDataFetcher
implements DataFetcher {
    private final Method method;
    private final int envIndex;

    public MethodDataFetcher(Method method) {
        this.method = method;
        List parameterTypes = Arrays.asList(method.getParameters()).stream().map(Parameter::getType).collect(Collectors.toList());
        this.envIndex = parameterTypes.indexOf(DataFetchingEnvironment.class);
    }

    public Object get(DataFetchingEnvironment environment) {
        if (environment.getSource() == null) {
            return null;
        }
        try {
            ArrayList args = new ArrayList(environment.getArguments().values());
            if (this.envIndex >= 0) {
                args.add(this.envIndex, environment);
            }
            return this.method.invoke(environment.getSource(), args.toArray());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

