/*
 * Decompiled with CFR 0.152.
 */
package io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe.internal;

import io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe.CircuitBreaker;
import io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe.ExecutionContext;
import io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe.internal.CircuitBreakerInternals;
import io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe.internal.CircuitState;
import io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe.internal.CircuitStats;

public class ClosedState
extends CircuitState {
    private final CircuitBreakerInternals internals;

    public ClosedState(CircuitBreaker breaker, CircuitBreakerInternals internals) {
        super(breaker, CircuitStats.create(breaker, ClosedState.capacityFor(breaker), true, null));
        this.internals = internals;
    }

    @Override
    public boolean allowsExecution() {
        return true;
    }

    @Override
    public CircuitBreaker.State getState() {
        return CircuitBreaker.State.CLOSED;
    }

    @Override
    public synchronized void handleConfigChange() {
        this.stats = CircuitStats.create(this.breaker, ClosedState.capacityFor(this.breaker), true, this.stats);
    }

    @Override
    synchronized void checkThreshold(ExecutionContext context) {
        double failureRateThreshold;
        if (this.stats.getExecutionCount() >= this.breaker.getFailureExecutionThreshold() && ((failureRateThreshold = (double)this.breaker.getFailureRateThreshold()) != 0.0 && (double)this.stats.getFailureRate() >= failureRateThreshold || failureRateThreshold == 0.0 && this.stats.getFailureCount() >= this.breaker.getFailureThreshold())) {
            this.internals.open(context);
        }
    }

    private static int capacityFor(CircuitBreaker<?> breaker) {
        if (breaker.getFailureExecutionThreshold() != 0) {
            return breaker.getFailureExecutionThreshold();
        }
        return breaker.getFailureThresholdingCapacity();
    }
}

