/*
 * Decompiled with CFR 0.152.
 */
package io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe;

import io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe.AbstractExecution;
import io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe.ExecutionResult;
import io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe.FailsafeExecutor;
import io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe.Policy;
import io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe.PolicyExecutor;
import io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe.internal.util.Assert;
import io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe.internal.util.DelegatingScheduler;
import java.util.Arrays;
import java.util.function.Supplier;

public class Execution<R>
extends AbstractExecution<R> {
    @SafeVarargs
    public Execution(Policy<R> ... policies) {
        super(DelegatingScheduler.INSTANCE, new FailsafeExecutor(Arrays.asList((Object[])Assert.notNull(policies, "policies"))));
        this.preExecute();
    }

    Execution(FailsafeExecutor<R> executor) {
        super(DelegatingScheduler.INSTANCE, executor);
    }

    public boolean canRetryFor(R result) {
        this.preExecute();
        this.postExecute(new ExecutionResult(result, null));
        return !this.completed;
    }

    public boolean canRetryFor(R result, Throwable failure) {
        this.preExecute();
        this.postExecute(new ExecutionResult(result, failure));
        return !this.completed;
    }

    public boolean canRetryOn(Throwable failure) {
        Assert.notNull(failure, "failure");
        this.preExecute();
        this.postExecute(new ExecutionResult(null, failure));
        return !this.completed;
    }

    public void complete() {
        this.postExecute(ExecutionResult.NONE);
    }

    public boolean complete(R result) {
        this.preExecute();
        this.postExecute(new ExecutionResult(result, null));
        return this.completed;
    }

    public boolean recordFailure(Throwable failure) {
        return this.canRetryOn(failure);
    }

    ExecutionResult executeSync(Supplier<ExecutionResult> supplier) {
        for (PolicyExecutor policyExecutor : this.policyExecutors) {
            supplier = policyExecutor.supply(supplier, this.scheduler);
        }
        ExecutionResult result = supplier.get();
        this.completed = result.isComplete();
        this.executor.handleComplete(result, this);
        return result;
    }
}

