/*
 * Decompiled with CFR 0.152.
 */
package com.gongbo.export.utils;

import com.gongbo.export.utils.CollectionUtil;
import com.gongbo.export.utils.StringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;

public class Utils {
    public static <T> T firstNotNull(T ... values) {
        for (T value : values) {
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @SafeVarargs
    public static <T> T firstNotNull(Supplier<T> ... values) {
        for (Supplier<T> supplier : values) {
            T value = supplier.get();
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static String firstNotEmpty(String ... values) {
        for (String value : values) {
            if (!StringUtil.isNotEmpty(value)) continue;
            return value;
        }
        return null;
    }

    @SafeVarargs
    public static String firstNotEmpty(Supplier<String> ... values) {
        for (Supplier<String> supplier : values) {
            String value = supplier.get();
            if (!StringUtil.isNotEmpty(value)) continue;
            return value;
        }
        return null;
    }

    public static <T> Collection<T> firstNotEmpty(Collection<T> ... values) {
        for (Collection<T> value : values) {
            if (!CollectionUtil.isNotEmpty(value)) continue;
            return value;
        }
        return Collections.emptyList();
    }

    private Utils() {
    }
}

