/*
 * Decompiled with CFR 0.152.
 */
package com.gongbo.export.entity;

import com.gongbo.export.utils.StringUtil;
import com.gongbo.export.utils.Utils;
import java.text.MessageFormat;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;

public class ExportParam {
    public static final String EXPORT = "export";
    public static final String EXPORT_TAG = "export_tag";
    private String exportTag;
    private Type type;

    public static ExportParam parse(HttpServletRequest request) {
        String export = Utils.firstNotEmpty(() -> request.getParameter(EXPORT), () -> request.getHeader(EXPORT));
        if (StringUtil.isEmpty(export)) {
            return null;
        }
        Type type = Type.of(export);
        Objects.requireNonNull(type, MessageFormat.format("Export request parameter error:{0}", export));
        String exportTag = Utils.firstNotEmpty(() -> request.getParameter(EXPORT_TAG), () -> request.getHeader(EXPORT_TAG));
        return ExportParam.builder().exportTag(exportTag).type(type).build();
    }

    public boolean isInfo() {
        return Type.EXPORT_INFO.equals((Object)this.type);
    }

    public boolean isExcel() {
        return Type.EXPORT_EXCEL.equals((Object)this.type);
    }

    public static ExportParamBuilder builder() {
        return new ExportParamBuilder();
    }

    public void setExportTag(String exportTag) {
        this.exportTag = exportTag;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getExportTag() {
        return this.exportTag;
    }

    public Type getType() {
        return this.type;
    }

    public ExportParam() {
    }

    public ExportParam(String exportTag, Type type) {
        this.exportTag = exportTag;
        this.type = type;
    }

    public static class ExportParamBuilder {
        private String exportTag;
        private Type type;

        ExportParamBuilder() {
        }

        public ExportParamBuilder exportTag(String exportTag) {
            this.exportTag = exportTag;
            return this;
        }

        public ExportParamBuilder type(Type type) {
            this.type = type;
            return this;
        }

        public ExportParam build() {
            return new ExportParam(this.exportTag, this.type);
        }

        public String toString() {
            return "ExportParam.ExportParamBuilder(exportTag=" + this.exportTag + ", type=" + (Object)((Object)this.type) + ")";
        }
    }

    public static enum Type {
        EXPORT_INFO("info"),
        EXPORT_EXCEL("excel");

        private final String value;

        public static Type of(String value) {
            for (Type type : Type.values()) {
                if (!type.value.equals(value)) continue;
                return type;
            }
            return null;
        }

        private Type(String value) {
            this.value = value;
        }
    }
}

