/*
 * Decompiled with CFR 0.152.
 */
package com.gongbo.export.core;

import com.gongbo.export.entity.ExportContext;
import com.gongbo.export.entity.ExportParam;
import java.util.Optional;

public class ExportContextHolder {
    private static final ThreadLocal<ExportContext> THREAD_LOCAL = new ThreadLocal();

    public static boolean isExportExcel() {
        return Optional.ofNullable(ExportContextHolder.getContext()).map(ExportContext::getExportParam).map(ExportParam::isExcel).orElse(false);
    }

    public static ExportContext getContext() {
        return THREAD_LOCAL.get();
    }

    public static void setContext(ExportContext exportContext) {
        THREAD_LOCAL.set(exportContext);
    }

    public static void clear() {
        THREAD_LOCAL.remove();
    }

    private ExportContextHolder() {
    }
}

