/*
 * Decompiled with CFR 0.152.
 */
package io.github.goldfish07.reschiper.plugin.tasks;

import com.android.build.gradle.api.ApplicationVariant;
import io.github.goldfish07.reschiper.plugin.Extension;
import io.github.goldfish07.reschiper.plugin.command.Command;
import io.github.goldfish07.reschiper.plugin.command.model.DuplicateResMergerCommand;
import io.github.goldfish07.reschiper.plugin.command.model.FileFilterCommand;
import io.github.goldfish07.reschiper.plugin.command.model.ObfuscateBundleCommand;
import io.github.goldfish07.reschiper.plugin.command.model.StringFilterCommand;
import io.github.goldfish07.reschiper.plugin.internal.Bundle;
import io.github.goldfish07.reschiper.plugin.internal.SigningConfig;
import io.github.goldfish07.reschiper.plugin.model.KeyStore;
import java.io.File;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

public class ResChiperTask
extends DefaultTask {
    private static final Logger logger = Logger.getLogger(ResChiperTask.class.getName());
    private final Extension resChiperExtension = (Extension)this.getProject().getExtensions().getByName("resChiper");
    private ApplicationVariant variant;
    private KeyStore keyStore;
    private Path bundlePath;
    private Path obfuscatedBundlePath;

    public ResChiperTask() {
        this.setDescription("Assemble resource proguard for bundle file");
        this.setGroup("bundle");
        this.getOutputs().upToDateWhen(task -> false);
    }

    public void setVariantScope(ApplicationVariant variant) {
        this.variant = variant;
        this.bundlePath = Bundle.getBundleFilePath(this.getProject(), variant);
        this.obfuscatedBundlePath = new File(this.bundlePath.toFile().getParentFile(), this.resChiperExtension.getObfuscatedBundleName()).toPath();
    }

    @TaskAction
    private void execute() throws Exception {
        logger.log(Level.INFO, this.resChiperExtension.toString());
        this.keyStore = SigningConfig.getSigningConfig(this.variant);
        this.printSignConfiguration();
        this.printOutputFileLocation();
        this.prepareUnusedFile();
        Command.Builder builder = Command.builder();
        builder.setBundlePath(this.bundlePath);
        builder.setOutputPath(this.obfuscatedBundlePath);
        ObfuscateBundleCommand.Builder obfuscateBuilder = ObfuscateBundleCommand.builder().setEnableObfuscate(this.resChiperExtension.getEnableObfuscation()).setObfuscationMode(this.resChiperExtension.getObfuscationMode()).setMergeDuplicatedResources(this.resChiperExtension.getMergeDuplicateResources()).setWhiteList(this.resChiperExtension.getWhiteList()).setFilterFile(this.resChiperExtension.getEnableFileFiltering()).setFileFilterRules(this.resChiperExtension.getFileFilterList()).setRemoveStr(this.resChiperExtension.getEnableFilterStrings()).setUnusedStrPath(this.resChiperExtension.getUnusedStringFile()).setLanguageWhiteList(this.resChiperExtension.getLocaleWhiteList());
        if (this.resChiperExtension.getMappingFile() != null) {
            obfuscateBuilder.setMappingPath(this.resChiperExtension.getMappingFile());
        }
        if (this.keyStore.storeFile() != null && this.keyStore.storeFile().exists()) {
            builder.setStoreFile(this.keyStore.storeFile().toPath()).setKeyAlias(this.keyStore.keyAlias()).setKeyPassword(this.keyStore.keyPassword()).setStorePassword(this.keyStore.storePassword());
        }
        builder.setObfuscateBundleBuilder(obfuscateBuilder.build());
        FileFilterCommand.Builder fileFilterBuilder = FileFilterCommand.builder();
        fileFilterBuilder.setFileFilterRules(this.resChiperExtension.getFileFilterList());
        builder.setFileFilterBuilder(fileFilterBuilder.build());
        StringFilterCommand.Builder stringFilterBuilder = StringFilterCommand.builder();
        builder.setStringFilterBuilder(stringFilterBuilder.build());
        DuplicateResMergerCommand.Builder duplicateResMergeBuilder = DuplicateResMergerCommand.builder();
        builder.setDuplicateResMergeBuilder(duplicateResMergeBuilder.build());
        Command command = builder.build(builder.build(), Command.TYPE.OBFUSCATE_BUNDLE);
        command.execute(Command.TYPE.OBFUSCATE_BUNDLE);
    }

    private void prepareUnusedFile() {
        String simpleName = this.variant.getName().replace("Release", "");
        String name = Character.toLowerCase(simpleName.charAt(0)) + simpleName.substring(1);
        String resourcePath = this.getProject().getBuildDir() + "/outputs/mapping/" + name + "/release/unused_strings.txt";
        File usedFile = new File(resourcePath);
        if (usedFile.exists()) {
            System.out.println("find unused_strings.txt: " + usedFile.getAbsolutePath());
            if (this.resChiperExtension.getEnableFilterStrings() && (this.resChiperExtension.getUnusedStringFile() == null || this.resChiperExtension.getUnusedStringFile().isBlank())) {
                this.resChiperExtension.setUnusedStringFile(usedFile.getAbsolutePath());
                logger.log(Level.SEVERE, "replace unused_strings.txt!");
            }
        } else {
            logger.log(Level.SEVERE, "not exists unused_strings.txt: " + usedFile.getAbsolutePath() + "\nuse default path: " + this.resChiperExtension.getUnusedStringFile());
        }
    }

    private void printSignConfiguration() {
        System.out.println("----------------------------------------");
        System.out.println(" Signing Configuration");
        System.out.println("----------------------------------------");
        System.out.println("\tKeyStoreFile:\t\t" + this.keyStore.storeFile());
        System.out.println("\tKeyPassword:\t" + this.encrypt(this.keyStore.keyPassword()));
        System.out.println("\tAlias:\t\t\t" + this.encrypt(this.keyStore.keyAlias()));
        System.out.println("\tStorePassword:\t" + this.encrypt(this.keyStore.storePassword()));
    }

    private void printOutputFileLocation() {
        System.out.println("----------------------------------------");
        System.out.println(" Output configuration");
        System.out.println("----------------------------------------");
        System.out.println("\tFolder:\t\t" + this.obfuscatedBundlePath.getParent());
        System.out.println("\tFile:\t\t" + this.obfuscatedBundlePath.getFileName());
        System.out.println("----------------------------------------");
    }

    @NotNull
    private String encrypt(String value) {
        if (value == null) {
            return "/";
        }
        if (value.length() > 2) {
            return value.substring(0, value.length() / 2) + "****";
        }
        return "****";
    }
}

