/*
 * Decompiled with CFR 0.152.
 */
package io.github.goldfish07.reschiper.plugin.parser;

import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import io.github.goldfish07.reschiper.plugin.parser.xml.FileFilterConfig;
import io.github.goldfish07.reschiper.plugin.parser.xml.ResChiperConfig;
import io.github.goldfish07.reschiper.plugin.parser.xml.StringFilterConfig;
import java.nio.file.Path;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class Parser {

    public static class XML {
        private final Path configPath;

        public XML(Path configPath) {
            FilePreconditions.checkFileExistsAndReadable((Path)configPath);
            this.configPath = configPath;
        }

        public FileFilterConfig fileFilterParse() throws DocumentException {
            FileFilterConfig fileFilter = new FileFilterConfig();
            SAXReader reader = new SAXReader();
            Document doc = reader.read(this.configPath.toFile());
            Element root = doc.getRootElement();
            Iterator i = root.elementIterator("filter");
            while (i.hasNext()) {
                Element element = (Element)i.next();
                String isActiveValue = element.attributeValue("isactive");
                if (isActiveValue != null && isActiveValue.equals("true")) {
                    fileFilter.setActive(true);
                }
                Iterator rules = element.elementIterator("rule");
                while (rules.hasNext()) {
                    Element ruleElement = (Element)rules.next();
                    String rule = ruleElement.attributeValue("value");
                    if (rule == null) continue;
                    fileFilter.addRule(rule);
                }
            }
            return fileFilter;
        }

        public ResChiperConfig resChiperParse() throws DocumentException {
            ResChiperConfig resChiperConfig = new ResChiperConfig();
            SAXReader reader = new SAXReader();
            Document doc = reader.read(this.configPath.toFile());
            Element root = doc.getRootElement();
            Iterator i = root.elementIterator("issue");
            while (i.hasNext()) {
                Element element = (Element)i.next();
                String id = element.attributeValue("id");
                if (id == null || !id.equals("whitelist")) continue;
                String isActive = element.attributeValue("isactive");
                if (isActive != null && isActive.equals("true")) {
                    resChiperConfig.setUseWhiteList(true);
                }
                Iterator rules = element.elementIterator("path");
                while (rules.hasNext()) {
                    Element ruleElement = (Element)rules.next();
                    String rule = ruleElement.attributeValue("value");
                    if (rule == null) continue;
                    resChiperConfig.addWhiteList(rule);
                }
            }
            resChiperConfig.setFileFilter(this.fileFilterParse());
            resChiperConfig.setStringFilterConfig(this.stringFilterParse());
            return resChiperConfig;
        }

        public StringFilterConfig stringFilterParse() throws DocumentException {
            StringFilterConfig config = new StringFilterConfig();
            SAXReader reader = new SAXReader();
            Document doc = reader.read(this.configPath.toFile());
            Element root = doc.getRootElement();
            Iterator i = root.elementIterator("filter-str");
            while (i.hasNext()) {
                String path;
                Element ruleElement;
                Element element = (Element)i.next();
                String isActive = element.attributeValue("isactive");
                if (isActive != null && isActive.equalsIgnoreCase("true")) {
                    config.setActive(true);
                }
                Iterator rules = element.elementIterator("path");
                while (rules.hasNext()) {
                    ruleElement = (Element)rules.next();
                    path = ruleElement.attributeValue("value");
                    config.setPath(path);
                }
                rules = element.elementIterator("language");
                while (rules.hasNext()) {
                    ruleElement = (Element)rules.next();
                    path = ruleElement.attributeValue("value");
                    config.getLanguageWhiteList().add(path);
                }
            }
            return config;
        }
    }
}

