/*
 * Decompiled with CFR 0.152.
 */
package io.github.goldfish07.reschiper.plugin.operations;

import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.ZipUtils;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.model.utils.files.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;

public class FileOperation {
    private static final Logger logger = Logger.getLogger(FileOperation.class.getName());
    private static final int BUFFER = 8192;

    public static boolean deleteDir(File file) {
        File[] files;
        if (file == null || !file.exists()) {
            return false;
        }
        if (file.isFile()) {
            file.delete();
        } else if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File value : files) {
                FileOperation.deleteDir(value);
            }
        }
        file.delete();
        return true;
    }

    public static void uncompress(Path uncompressedFile, Path targetDir) throws IOException {
        ZipFile zipFile;
        FilePreconditions.checkFileExistsAndReadable((Path)uncompressedFile);
        if (Files.exists(targetDir, new LinkOption[0])) {
            targetDir.toFile().delete();
        } else {
            FileUtils.createDirectories((Path)targetDir);
        }
        try (ZipFile zipFile2 = zipFile = new ZipFile(uncompressedFile.toFile());){
            Enumeration<? extends ZipEntry> emu = zipFile.entries();
            while (emu.hasMoreElements()) {
                int len;
                ZipEntry entry = emu.nextElement();
                if (entry.isDirectory()) {
                    FileUtils.createDirectories((Path)new File(targetDir.toFile(), entry.getName()).toPath());
                    continue;
                }
                BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));
                File file = new File(targetDir.toFile() + File.separator + entry.getName());
                File parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    FileUtils.createDirectories((Path)parent.toPath());
                }
                FileOutputStream fos = new FileOutputStream(file);
                BufferedOutputStream bos = new BufferedOutputStream(fos, 8192);
                byte[] buf = new byte[8192];
                while ((len = bis.read(buf, 0, 8192)) != -1) {
                    fos.write(buf, 0, len);
                }
                bos.flush();
                bos.close();
                bis.close();
            }
        }
    }

    @NotNull
    public static String getNetFileSizeDescription(long size) {
        StringBuilder bytes = new StringBuilder();
        DecimalFormat format = new DecimalFormat("###.0");
        if (size >= 0x40000000L) {
            double i = (double)size / 1.073741824E9;
            bytes.append(format.format(i)).append("GB");
        } else if (size >= 0x100000L) {
            double i = (double)size / 1048576.0;
            bytes.append(format.format(i)).append("MB");
        } else if (size >= 1024L) {
            double i = (double)size / 1024.0;
            bytes.append(format.format(i)).append("KB");
        } else if (size <= 0L) {
            bytes.append("0B");
        } else {
            bytes.append((int)size).append("B");
        }
        return bytes.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFileSizes(@NotNull File f) {
        long size = 0L;
        if (f.exists() && f.isFile()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(f);
                size = fis.available();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Unable to get FileSize", e);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Unable to get file size", e);
                }
            }
        }
        return size;
    }

    public static long getZipPathFileSize(ZipFile zipFile, ZipEntry zipEntry) {
        long size = 0L;
        try {
            InputStream is = ZipUtils.asByteSource((ZipFile)zipFile, (ZipEntry)zipEntry).openStream();
            size = is.available();
            is.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Unable to get ZipPath file size", e);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileUsingStream(File source, @NotNull File dest) throws IOException {
        FileInputStream is = null;
        FileOutputStream os = null;
        File parent = dest.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        try {
            int length;
            is = new FileInputStream(source);
            os = new FileOutputStream(dest, false);
            byte[] buffer = new byte[8192];
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    @NotNull
    public static String getFileSimpleName(@NotNull ZipPath zipPath) {
        return zipPath.getFileName().toString();
    }

    @NotNull
    public static String getFileSuffix(@NotNull ZipPath zipPath) {
        String fileName = zipPath.getName(zipPath.getNameCount() - 1).toString();
        if (!fileName.contains(".")) {
            return fileName;
        }
        String[] values = fileName.replace(".", "/").split("/");
        return fileName.substring(values[0].length());
    }

    @NotNull
    public static String getParentFromZipFilePath(@NotNull String zipPath) {
        if (!zipPath.contains("/")) {
            throw new IllegalArgumentException("invalid zipPath: " + zipPath);
        }
        String[] values = zipPath.split("/");
        return zipPath.substring(0, zipPath.indexOf(values[values.length - 1]) - 1);
    }

    public static String getNameFromZipFilePath(@NotNull String zipPath) {
        if (!zipPath.contains("/")) {
            throw new IllegalArgumentException("invalid zipPath: " + zipPath);
        }
        String[] values = zipPath.split("/");
        return values[values.length - 1];
    }

    public static String getFilePrefixByFileName(@NotNull String fileName) {
        if (!fileName.contains(".")) {
            throw new IllegalArgumentException("invalid file name: " + fileName);
        }
        String[] values = fileName.replace(".", "/").split("/");
        return values[0];
    }
}

