/*
 * Decompiled with CFR 0.152.
 */
package io.github.goldfish07.reschiper.plugin.obfuscation;

import io.github.goldfish07.reschiper.plugin.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class StringObfuscator {
    private final List<String> replaceStringBuffer = new ArrayList<String>();
    private final Set<Integer> isReplaced = new HashSet<Integer>();
    private final Set<Integer> isWhiteList = new HashSet<Integer>();
    private static final String[] A_TO_Z = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    private static final String[] A_TO_ALL = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "_", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    private static final Set<String> FILE_NAME_BLACKLIST = new HashSet<String>(Arrays.asList("con", "prn", "aux", "nul"));
    private static final int MAX_OBFUSCATION_LIMIT = 35594;

    public void reset(HashSet<Pattern> blacklistPatterns) {
        this.replaceStringBuffer.clear();
        this.isReplaced.clear();
        this.isWhiteList.clear();
        for (String str : A_TO_Z) {
            if (!Utils.match(str, blacklistPatterns)) continue;
            this.replaceStringBuffer.add(str);
        }
        for (String first : A_TO_Z) {
            for (String aMAToAll : A_TO_ALL) {
                String str = first + aMAToAll;
                if (!Utils.match(str, blacklistPatterns)) continue;
                this.replaceStringBuffer.add(str);
            }
        }
        for (String first : A_TO_Z) {
            for (String second : A_TO_ALL) {
                for (String third : A_TO_ALL) {
                    String str = first + second + third;
                    if (FILE_NAME_BLACKLIST.contains(str) || !Utils.match(str, blacklistPatterns)) continue;
                    this.replaceStringBuffer.add(str);
                }
            }
        }
    }

    public void removeStrings(Collection<String> collection) {
        if (collection == null) {
            return;
        }
        this.replaceStringBuffer.removeAll(collection);
    }

    public boolean isReplaced(int id) {
        return this.isReplaced.contains(id);
    }

    public boolean isInWhiteList(int id) {
        return this.isWhiteList.contains(id);
    }

    public void setInWhiteList(int id) {
        this.isWhiteList.add(id);
    }

    public void setInReplaceList(int id) {
        this.isReplaced.add(id);
    }

    public String getReplaceString(Collection<String> names) throws IllegalArgumentException {
        if (this.replaceStringBuffer.isEmpty()) {
            throw new IllegalArgumentException("Now can only obfuscate up to 35594 in a single type");
        }
        if (names != null) {
            for (int i = 0; i < this.replaceStringBuffer.size(); ++i) {
                String name = this.replaceStringBuffer.get(i);
                if (names.contains(name)) continue;
                return this.replaceStringBuffer.remove(i);
            }
        }
        return this.replaceStringBuffer.remove(0);
    }
}

