/*
 * Decompiled with CFR 0.152.
 */
package io.github.goldfish07.reschiper.plugin.android;

import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.google.common.base.Joiner;
import io.github.goldfish07.reschiper.plugin.android.JarSigner;
import io.github.goldfish07.reschiper.plugin.android.PlatformDetector;
import io.github.goldfish07.reschiper.plugin.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenJDKJarSigner {
    private static final String jarSignerExec = PlatformDetector.currentPlatform() == 2 ? "jarsigner.exe" : "jarsigner";
    private static final Logger logger = Logger.getLogger(OpenJDKJarSigner.class.getName());

    public void sign(@NotNull File toBeSigned, @NotNull JarSigner.Signature signature) throws IOException, InterruptedException {
        FilePreconditions.checkFileExistsAndReadable((Path)toBeSigned.toPath());
        FilePreconditions.checkFileExistsAndReadable((Path)signature.storeFile());
        File jarSigner = this.locatedJarSigner();
        ArrayList<String> args = new ArrayList<String>();
        if (jarSigner != null) {
            args.add(jarSigner.getAbsolutePath());
        } else {
            args.add(jarSignerExec);
        }
        args.add("-keystore");
        args.add(signature.storeFile().toFile().getAbsolutePath());
        File keyStorePasswordFile = null;
        File aliasPasswordFile = null;
        if (signature.storePassword() != null) {
            keyStorePasswordFile = File.createTempFile("store", "prv");
            FileUtils.writeToFile(keyStorePasswordFile, signature.storePassword());
            args.add("-storepass:file");
            args.add(keyStorePasswordFile.getAbsolutePath());
        }
        if (signature.keyPassword() != null) {
            aliasPasswordFile = File.createTempFile("alias", "prv");
            FileUtils.writeToFile(aliasPasswordFile, signature.keyPassword());
            args.add("--keypass:file");
            args.add(aliasPasswordFile.getAbsolutePath());
        }
        args.add(toBeSigned.getAbsolutePath());
        if (signature.keyAlias() != null) {
            args.add(signature.keyAlias());
        }
        File errorLog = File.createTempFile("error", ".log");
        File outputLog = File.createTempFile("output", ".log");
        logger.fine("Invoking " + Joiner.on((String)" ").join(args));
        Process process = this.start(new ProcessBuilder(args).redirectError(errorLog).redirectOutput(outputLog));
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            String errors = FileUtils.loadFileWithUnixLineSeparators(errorLog);
            String output = FileUtils.loadFileWithUnixLineSeparators(outputLog);
            throw new RuntimeException(String.format("%s failed with exit code %d: \n %s", jarSignerExec, exitCode, errors.trim().isEmpty() ? output : errors));
        }
        if (keyStorePasswordFile != null) {
            keyStorePasswordFile.delete();
        }
        if (aliasPasswordFile != null) {
            aliasPasswordFile.delete();
        }
    }

    @Contract(value="_ -> new")
    private Process start(@NotNull ProcessBuilder builder) throws IOException {
        return builder.start();
    }

    @Nullable
    private File locatedJarSigner() {
        File javaHome = new File(System.getProperty("java.home"));
        File jarSigner = this.getJarSigner(javaHome);
        if (jarSigner.exists()) {
            return jarSigner;
        }
        jarSigner = this.getJarSigner(javaHome.getParentFile());
        return jarSigner.exists() ? jarSigner : null;
    }

    @Contract(value="_ -> new")
    @NotNull
    private File getJarSigner(File parentDir) {
        return new File(new File(parentDir, "bin"), jarSignerExec);
    }
}

