/*
 * Decompiled with CFR 0.152.
 */
package io.github.glytching.junit.extension.testname;

import io.github.glytching.junit.extension.testname.TestName;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class TestNameExtension
implements BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    public void beforeTestExecution(ExtensionContext extensionContext) throws Exception {
        this.setTestNameFieldValue(this.getTestNameField(extensionContext), extensionContext.getRequiredTestInstance(), extensionContext.getRequiredTestMethod().getName());
    }

    public void afterTestExecution(ExtensionContext extensionContext) throws Exception {
        this.setTestNameFieldValue(this.getTestNameField(extensionContext), extensionContext.getRequiredTestInstance(), null);
    }

    private Optional<Field> getTestNameField(ExtensionContext extensionContext) {
        for (Field field : extensionContext.getRequiredTestClass().getDeclaredFields()) {
            if (!AnnotationSupport.isAnnotated((AnnotatedElement)field, TestName.class)) continue;
            return Optional.of(field);
        }
        return Optional.empty();
    }

    private void setTestNameFieldValue(Optional<Field> testNameField, Object testInstance, String value) throws IllegalAccessException {
        if (testNameField.isPresent()) {
            testNameField.get().setAccessible(true);
            testNameField.get().set(testInstance, value);
        }
    }
}

