/*
 * Decompiled with CFR 0.152.
 */
package io.github.gltomasz;

import io.github.gltomasz.InformixContainer;
import java.util.Map;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.JdbcDatabaseContainerProvider;
import org.testcontainers.jdbc.ConnectionUrl;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class InformixContainerProvider
extends JdbcDatabaseContainerProvider {
    public static final String FULL_IMAGE_NAME = "ibmcom/informix-developer-database";
    private static final String IFX_CONFIG_DIR = "/opt/ibm/config/";
    private static final String TC_INIT_IFX = "TC_INIT_IFX";
    private static final String TC_POSTINIT_IFX = "TC_POSTINIT_IFX";

    public boolean supports(String databaseType) {
        return databaseType.equals("informix");
    }

    public JdbcDatabaseContainer newInstance(String s) {
        return this.newInformixInstance(s);
    }

    public JdbcDatabaseContainer newInstance(ConnectionUrl url) {
        Map containerParameters = url.getContainerParameters();
        InformixContainer result = this.newInformixInstance(url.getImageTag().orElse("latest"));
        if (containerParameters.containsKey(TC_INIT_IFX)) {
            result.withInitFile((String)containerParameters.get(TC_INIT_IFX)).withCopyFileToContainer(MountableFile.forClasspathResource((String)((String)containerParameters.get(TC_INIT_IFX))), IFX_CONFIG_DIR);
        }
        if (containerParameters.containsKey(TC_POSTINIT_IFX)) {
            result.withPostInitFile((String)containerParameters.get(TC_POSTINIT_IFX)).withCopyFileToContainer(MountableFile.forClasspathResource((String)((String)containerParameters.get(TC_POSTINIT_IFX))), IFX_CONFIG_DIR);
        }
        result.withDatabaseName(url.getDbHostString().replace("/", ""));
        result.withReuse(url.isReusable());
        return result;
    }

    private InformixContainer newInformixInstance(String tag) {
        return new InformixContainer(DockerImageName.parse((String)FULL_IMAGE_NAME).withTag(tag));
    }
}

