/*
 * Decompiled with CFR 0.152.
 */
package io.github.gltomasz;

import java.text.MessageFormat;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;
import org.testcontainers.utility.DockerImageName;

class InformixContainer<SELF extends InformixContainer<SELF>>
extends JdbcDatabaseContainer<SELF> {
    public static final int INFORMIX_PORT = 9088;
    static final String DEFAULT_USER = "informix";
    static final String DEFAULT_PASSWORD = "in4mix";
    private String databaseName = "sysadmin";

    public InformixContainer() {
        this(DockerImageName.parse((String)"ibmcom/informix-developer-database:latest"));
    }

    public InformixContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        this.waitStrategy = new LogMessageWaitStrategy().withRegEx(".*Maximum server connections 1.*").withTimes(1).withStartupTimeout(Duration.of(60L, ChronoUnit.SECONDS));
        this.addExposedPort(9088);
    }

    protected void configure() {
        this.addEnv("LICENSE", "accept");
    }

    public String getDriverClassName() {
        return "com.informix.jdbc.IfxDriver";
    }

    public String getJdbcUrl() {
        String additionalUrlParams = this.constructUrlParameters("?", "&");
        return MessageFormat.format("jdbc:informix-sqli://{0}:{1}/{2}:INFORMIXSERVER=informix{3}", this.getContainerIpAddress(), this.getMappedPort(9088), this.getDatabaseName(), additionalUrlParams);
    }

    public String getUsername() {
        return DEFAULT_USER;
    }

    public String getPassword() {
        return DEFAULT_PASSWORD;
    }

    protected String getTestQueryString() {
        return "select count(*) from systables";
    }

    protected void waitUntilContainerStarted() {
        this.getWaitStrategy().waitUntilReady((WaitStrategyTarget)this);
    }

    public SELF withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return (SELF)((Object)((InformixContainer)this.self()));
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public SELF withInitFile(String fileName) {
        this.addEnv("INIT_FILE", fileName);
        return (SELF)((Object)((InformixContainer)this.self()));
    }

    public SELF withPostInitFile(String fileName) {
        this.addEnv("RUN_FILE_POST_INIT", fileName);
        return (SELF)((Object)((InformixContainer)this.self()));
    }
}

