/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core.cibuild;

import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import pl.project13.core.cibuild.BuildServerDataProvider;
import pl.project13.core.log.LogInterface;

public class GitHubBuildServerData
extends BuildServerDataProvider {
    GitHubBuildServerData(LogInterface log, @Nonnull Map<String, String> env) {
        super(log, env);
    }

    public static boolean isActiveServer(Map<String, String> env) {
        return env.containsKey("GITHUB_ACTIONS");
    }

    @Override
    void loadBuildNumber(@Nonnull Properties properties) {
    }

    @Override
    public String getBuildBranch() {
        String gitHubRef = (String)this.env.get("GITHUB_REF");
        if (gitHubRef != null && !gitHubRef.isEmpty()) {
            if (gitHubRef.startsWith("refs/heads/")) {
                String branchName = gitHubRef.substring("refs/heads/".length());
                this.log.info(String.format("Using environment variable based branch name. GITHUB_REF = %s (branch = %s)", gitHubRef, branchName));
                return branchName;
            }
            if (gitHubRef.startsWith("refs/pull/")) {
                String branchName = (String)this.env.get("GITHUB_HEAD_REF");
                this.log.info(String.format("Using environment variable based branch name. GITHUB_HEAD_REF = %s", branchName));
                return branchName;
            }
        }
        return "";
    }
}

