/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core.cibuild;

import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import pl.project13.core.cibuild.BuildServerDataProvider;
import pl.project13.core.log.LogInterface;

public class AzureDevOpsBuildServerData
extends BuildServerDataProvider {
    AzureDevOpsBuildServerData(@Nonnull LogInterface log, @Nonnull Map<String, String> env) {
        super(log, env);
    }

    public static boolean isActiveServer(@Nonnull Map<String, String> env) {
        return env.containsKey("AZURE_HTTP_USER_AGENT") || env.containsKey("TF_BUILD");
    }

    @Override
    void loadBuildNumber(@Nonnull Properties properties) {
        String buildNumber = this.env.getOrDefault("BUILD_BUILDNUMBER", "");
        this.maybePut(properties, "build.number", () -> buildNumber);
    }

    @Override
    public String getBuildBranch() {
        String environmentBasedBuildSourceBranch = (String)this.env.get("BUILD_SOURCEBRANCH");
        if (environmentBasedBuildSourceBranch != null && !environmentBasedBuildSourceBranch.isEmpty()) {
            if (environmentBasedBuildSourceBranch.startsWith("refs/heads/")) {
                String branchName = environmentBasedBuildSourceBranch.substring("refs/heads/".length());
                this.log.info(String.format("Using environment variable based branch name. BUILD_SOURCEBRANCH = %s (branch = %s)", environmentBasedBuildSourceBranch, branchName));
                return branchName;
            }
            if (environmentBasedBuildSourceBranch.startsWith("refs/pull/")) {
                String branchName = environmentBasedBuildSourceBranch.substring("refs/pull/".length());
                this.log.info(String.format("Using environment variable based branch name. BUILD_SOURCEBRANCH = %s (branch = %s)", environmentBasedBuildSourceBranch, branchName));
                return branchName;
            }
            if (environmentBasedBuildSourceBranch.startsWith("refs/tags/")) {
                String branchName = environmentBasedBuildSourceBranch.substring("refs/tags/".length());
                this.log.info(String.format("Using environment variable based branch name. BUILD_SOURCEBRANCH = %s (branch = %s)", environmentBasedBuildSourceBranch, branchName));
                return branchName;
            }
        }
        return "";
    }
}

