/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git.build;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.maven.project.MavenProject;
import pl.project13.maven.git.build.BambooBuildServerData;
import pl.project13.maven.git.build.GitlabBuildServerData;
import pl.project13.maven.git.build.HudsonJenkinsBuildServerData;
import pl.project13.maven.git.build.TeamCityBuildServerData;
import pl.project13.maven.git.build.TravisBuildServerData;
import pl.project13.maven.git.build.UnknownBuildServerData;
import pl.project13.maven.git.log.LoggerBridge;
import pl.project13.maven.git.util.PropertyManager;

public abstract class BuildServerDataProvider {
    final LoggerBridge log;
    final Map<String, String> env;
    private String dateFormat = "yyyy-MM-dd'T'HH:mm:ssZ";
    private String dateFormatTimeZone = null;
    private String prefixDot = "";
    private MavenProject project = null;

    BuildServerDataProvider(@Nonnull LoggerBridge log, @Nonnull Map<String, String> env) {
        this.log = log;
        this.env = env;
    }

    public BuildServerDataProvider setDateFormat(@Nonnull String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    public BuildServerDataProvider setDateFormatTimeZone(@Nonnull String dateFormatTimeZone) {
        this.dateFormatTimeZone = dateFormatTimeZone;
        return this;
    }

    public BuildServerDataProvider setProject(@Nonnull MavenProject project) {
        this.project = project;
        return this;
    }

    public BuildServerDataProvider setPrefixDot(@Nonnull String prefixDot) {
        this.prefixDot = prefixDot;
        return this;
    }

    public static BuildServerDataProvider getBuildServerProvider(@Nonnull Map<String, String> env, @Nonnull LoggerBridge log) {
        if (BambooBuildServerData.isActiveServer(env)) {
            return new BambooBuildServerData(log, env);
        }
        if (GitlabBuildServerData.isActiveServer(env)) {
            return new GitlabBuildServerData(log, env);
        }
        if (HudsonJenkinsBuildServerData.isActiveServer(env)) {
            return new HudsonJenkinsBuildServerData(log, env);
        }
        if (TeamCityBuildServerData.isActiveServer(env)) {
            return new TeamCityBuildServerData(log, env);
        }
        if (TravisBuildServerData.isActiveServer(env)) {
            return new TravisBuildServerData(log, env);
        }
        return new UnknownBuildServerData(log, env);
    }

    public void loadBuildData(@Nonnull Properties properties) {
        this.loadBuildVersionAndTimeData(properties);
        this.loadBuildHostData(properties);
        this.loadBuildNumber(properties);
    }

    abstract void loadBuildNumber(@Nonnull Properties var1);

    public abstract String getBuildBranch();

    private void loadBuildVersionAndTimeData(@Nonnull Properties properties) {
        Date buildDate = new Date();
        SimpleDateFormat smf = new SimpleDateFormat(this.dateFormat);
        if (this.dateFormatTimeZone != null) {
            smf.setTimeZone(TimeZone.getTimeZone(this.dateFormatTimeZone));
        }
        this.put(properties, "build.time", smf.format(buildDate));
        if (this.project != null) {
            this.put(properties, "build.version", this.project.getVersion());
        }
    }

    private void loadBuildHostData(@Nonnull Properties properties) {
        Supplier<String> buildHostSupplier = () -> {
            String buildHost = null;
            try {
                buildHost = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.log.info("Unable to get build host, skipping property {}. Error message: {}", (Object)"build.host", (Object)e.getMessage());
            }
            return buildHost;
        };
        this.maybePut(properties, "build.host", buildHostSupplier);
    }

    protected void put(@Nonnull Properties properties, @Nonnull String key, String value) {
        String keyWithPrefix = this.prefixDot + key;
        this.log.info("Collected {} with value {}", (Object)keyWithPrefix, (Object)value);
        PropertyManager.putWithoutPrefix(properties, keyWithPrefix, value);
    }

    protected void maybePut(@Nonnull Properties properties, @Nonnull String key, Supplier<String> supplier) {
        String keyWithPrefix = this.prefixDot + key;
        if (properties.contains(keyWithPrefix)) {
            String propertyValue = properties.getProperty(keyWithPrefix);
            this.log.info("Using cached {} with value {}", (Object)keyWithPrefix, (Object)propertyValue);
        } else {
            String propertyValue = supplier.get();
            this.log.info("Collected {} with value {}", (Object)keyWithPrefix, (Object)propertyValue);
            PropertyManager.putWithoutPrefix(properties, keyWithPrefix, propertyValue);
        }
    }
}

