/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.jgit;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;

public class DescribeResult {
    private Optional<String> tagName = Optional.empty();
    private Optional<ObjectId> commitId = Optional.empty();
    private Optional<AbbreviatedObjectId> abbreviatedObjectId = Optional.empty();
    private int abbrev = 7;
    private int commitsAwayFromTag;
    private boolean dirty;
    private String dirtyMarker;
    private boolean forceLongFormat;
    private ObjectReader objectReader;
    public static final DescribeResult EMPTY = new DescribeResult("");

    public DescribeResult(@Nonnull String tagName) {
        this(tagName, false, Optional.empty());
    }

    public DescribeResult(@Nonnull ObjectReader objectReader, String tagName, int commitsAwayFromTag, @Nonnull ObjectId commitId) {
        this(objectReader, tagName, commitsAwayFromTag, commitId, false, Optional.empty(), false);
    }

    public DescribeResult(@Nonnull ObjectReader objectReader, @Nonnull ObjectId commitId) {
        this.objectReader = objectReader;
        this.commitId = Optional.of(commitId);
        this.abbreviatedObjectId = DescribeResult.createAbbreviatedCommitId(objectReader, commitId, this.abbrev);
    }

    public DescribeResult(@Nonnull ObjectReader objectReader, String tagName, int commitsAwayFromTag, ObjectId commitId, boolean dirty, String dirtyMarker) {
        this(objectReader, tagName, commitsAwayFromTag, commitId, dirty, Optional.of(dirtyMarker), false);
    }

    public DescribeResult(@Nonnull ObjectReader objectReader, String tagName, int commitsAwayFromTag, ObjectId commitId, boolean dirty, Optional<String> dirtyMarker, boolean forceLongFormat) {
        this(objectReader, commitId, dirty, dirtyMarker);
        this.tagName = Optional.of(tagName);
        this.commitsAwayFromTag = commitsAwayFromTag;
        this.forceLongFormat = forceLongFormat;
    }

    public DescribeResult(@Nonnull ObjectReader objectReader, @Nonnull ObjectId commitId, boolean dirty, @Nonnull Optional<String> dirtyMarker) {
        this.objectReader = objectReader;
        this.commitId = Optional.of(commitId);
        this.abbreviatedObjectId = DescribeResult.createAbbreviatedCommitId(objectReader, commitId, this.abbrev);
        this.dirty = dirty;
        this.dirtyMarker = dirtyMarker.orElse("");
    }

    public DescribeResult(@Nonnull String tagName, boolean dirty, @Nonnull Optional<String> dirtyMarker) {
        this.tagName = Optional.of(tagName);
        this.dirty = dirty;
        this.dirtyMarker = dirtyMarker.orElse("");
    }

    @Nonnull
    public DescribeResult withCommitIdAbbrev(int n) {
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)String.format("The --abbrev parameter must be >= 0, but it was: [%s]", n));
        this.abbrev = n;
        this.abbreviatedObjectId = DescribeResult.createAbbreviatedCommitId(this.objectReader, this.commitId.get(), this.abbrev);
        return this;
    }

    public String toString() {
        ArrayList<String> parts = this.abbrevZeroHidesCommitsPartOfDescribe() ? new ArrayList<String>(Collections.singletonList(this.tag())) : new ArrayList<String>(Arrays.asList(this.tag(), this.commitsAwayFromTag(), this.prefixedCommitId()));
        StringJoiner sj = new StringJoiner("-");
        parts.stream().filter(Objects::nonNull).forEach(sj::add);
        return sj.toString() + this.dirtyMarker();
    }

    private boolean abbrevZeroHidesCommitsPartOfDescribe() {
        return this.abbrev == 0;
    }

    @Nullable
    public String commitsAwayFromTag() {
        if (this.forceLongFormat) {
            return String.valueOf(this.commitsAwayFromTag);
        }
        return this.commitsAwayFromTag == 0 ? null : String.valueOf(this.commitsAwayFromTag);
    }

    @Nullable
    public String dirtyMarker() {
        return this.dirty ? this.dirtyMarker : "";
    }

    @Nullable
    public String prefixedCommitId() {
        if (this.abbreviatedObjectId.isPresent()) {
            String name = this.abbreviatedObjectId.get().name();
            return this.gPrefixedCommitId(name);
        }
        if (this.commitId.isPresent()) {
            String name = this.commitId.get().name();
            return this.gPrefixedCommitId(name);
        }
        return null;
    }

    private String gPrefixedCommitId(String name) {
        if (this.tagName.isPresent()) {
            return "g" + name;
        }
        return name;
    }

    private static Optional<AbbreviatedObjectId> createAbbreviatedCommitId(@Nonnull ObjectReader objectReader, ObjectId commitId, int requestedLength) {
        if (requestedLength < 2) {
            return Optional.empty();
        }
        try {
            AbbreviatedObjectId abbreviatedObjectId = objectReader.abbreviate((AnyObjectId)commitId, requestedLength);
            return Optional.of(abbreviatedObjectId);
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    @Nullable
    public ObjectId commitObjectId() {
        if (this.commitId.isPresent()) {
            return this.commitId.get();
        }
        return null;
    }

    @Nullable
    public String tag() {
        return this.tagName.orElse(null);
    }
}

